/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.annotations.PackagePrivate;
import de.larssh.utils.io.PeekableReader;
import de.larssh.utils.text.Characters;
import de.larssh.utils.text.Csv;
import de.larssh.utils.text.CsvRow;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@PackagePrivate
class CsvParser {
    private final char separator;
    private final char escaper;

    @PackagePrivate
    static void assertCsvInput(char separator, char escaper) {
        if (escaper == separator) {
            throw new IllegalArgumentException("The escape and separator characters must not be equal.");
        }
        if (escaper == '\r') {
            throw new IllegalArgumentException("The escape character must not be '\r'.");
        }
        if (escaper == '\n') {
            throw new IllegalArgumentException("The escape character must not be '\n'.");
        }
        if (separator == '\r') {
            throw new IllegalArgumentException("The separator character must not be '\r'.");
        }
        if (separator == '\n') {
            throw new IllegalArgumentException("The separator character must not be '\n'.");
        }
    }

    @PackagePrivate
    static boolean readNewLine(PeekableReader reader) throws IOException {
        if (!reader.hasNext()) {
            return false;
        }
        char character = reader.peek();
        if (character != '\r' && character != '\n') {
            return false;
        }
        reader.next();
        if (character == '\r' && reader.hasNext() && reader.peek() == '\n') {
            reader.next();
        }
        return true;
    }

    @PackagePrivate
    boolean isSeparatorOrNewLine(char character) {
        return character == this.separator || character == '\r' || character == '\n';
    }

    public Csv parse(Reader reader) throws IOException {
        try (PeekableReader peekableReader = new PeekableReader(reader);){
            Csv csv = this.parse(peekableReader);
            return csv;
        }
    }

    private Csv parse(PeekableReader reader) throws IOException {
        CsvParser.assertCsvInput(this.separator, this.escaper);
        Csv csv = new Csv();
        if (!reader.hasNext()) {
            return csv.unmodifiable();
        }
        CsvRow currentRow = new CsvRow(csv, csv.size(), new ArrayList<String>());
        csv.add((List<String>)currentRow);
        while (reader.hasNext()) {
            if (CsvParser.readNewLine(reader)) {
                if (!reader.hasNext()) {
                    return csv.unmodifiable();
                }
                currentRow = new CsvRow(csv, csv.size(), new ArrayList<String>());
                csv.add((List<String>)currentRow);
                continue;
            }
            currentRow.add(this.parseValue(reader));
            while (reader.hasNext() && reader.peek() == this.separator) {
                reader.next();
                currentRow.add(this.parseValue(reader));
            }
        }
        return csv.unmodifiable();
    }

    @PackagePrivate
    String parseValue(PeekableReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean isEscaped = this.readLeadingWhitespacesAndIsEscaped(reader, builder);
        while (reader.hasNext()) {
            if (this.readEscaperAndIsControlCharHandling(reader, isEscaped)) {
                String trailingWhitespaces;
                String string = trailingWhitespaces = isEscaped ? this.readWhitespaces(reader) : "";
                if (!reader.hasNext() || this.isSeparatorOrNewLine(reader.peek())) {
                    return builder.toString();
                }
                if (isEscaped) {
                    builder.append(this.escaper).append(trailingWhitespaces);
                }
            }
            builder.append(reader.next());
        }
        return builder.toString();
    }

    @PackagePrivate
    boolean readEscaperAndIsControlCharHandling(PeekableReader reader, boolean isEscaped) throws IOException {
        if (!isEscaped) {
            return true;
        }
        if (!reader.hasNext() || reader.peek() != this.escaper) {
            return false;
        }
        reader.next();
        return !reader.hasNext() || reader.peek() != this.escaper;
    }

    @PackagePrivate
    boolean readLeadingWhitespacesAndIsEscaped(PeekableReader reader, StringBuilder builder) throws IOException {
        String whitespaces = this.readWhitespaces(reader);
        if (reader.hasNext() && reader.peek() == this.escaper) {
            reader.next();
            return true;
        }
        builder.append(whitespaces);
        return false;
    }

    @PackagePrivate
    String readWhitespaces(PeekableReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (reader.hasNext()) {
            char character = reader.peek();
            if (character == this.escaper || !Characters.isAsciiWhitespace(character) || this.isSeparatorOrNewLine(character)) {
                return builder.toString();
            }
            builder.append(reader.next());
        }
        return builder.toString();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CsvParser(separator=" + this.separator + ", escaper=" + this.escaper + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CsvParser(char separator, char escaper) {
        this.separator = separator;
        this.escaper = escaper;
    }
}

