/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.annotations.PackagePrivate;
import de.larssh.utils.collection.ProxiedList;
import de.larssh.utils.text.Csv;
import de.larssh.utils.text.StringConverters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class CsvRow
extends ProxiedList<String> {
    private final Csv csv;
    private final int rowIndex;

    @PackagePrivate
    CsvRow(Csv csv, int rowIndex, List<String> data) {
        super(data);
        if (rowIndex < 0) {
            throw new IllegalArgumentException(String.format("CSV row index must not be less tan zero, but was %d.", rowIndex));
        }
        this.csv = csv;
        this.rowIndex = rowIndex;
    }

    public Optional<String> get(String header) {
        int index = this.getCsv().getHeaders().indexOf(header);
        return index == -1 || index >= this.size() ? Optional.empty() : Optional.of(this.get(index));
    }

    @Override
    public boolean isModifiable() {
        return this.getCsv().isModifiable();
    }

    @Override
    public String toString() {
        return this.toString(Csv.DEFAULT_SEPARATOR, Csv.DEFAULT_ESCAPER);
    }

    public String toString(char separator, char escaper) {
        return StringConverters.encodeCsvRow(this, separator, escaper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Csv getCsv() {
        return this.csv;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRowIndex() {
        return this.rowIndex;
    }
}

