/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.collection.Iterators;
import de.larssh.utils.collection.Maps;
import de.larssh.utils.collection.PeekableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class Lines {
    public static <T> Stream<List<T>> consecutive(Iterable<T> lines, BiPredicate<List<T>, T> isNextConsecutive) {
        return Lines.consecutive(lines.iterator(), isNextConsecutive);
    }

    public static <T> Stream<List<T>> consecutive(Iterator<T> linesIterator, BiPredicate<List<T>, T> isNextConsecutive) {
        PeekableIterator peekableLinesIterator = Iterators.peekableIterator(linesIterator);
        return Iterators.stream(state -> {
            ArrayList lines = new ArrayList();
            while (peekableLinesIterator.hasNext()) {
                lines.add(peekableLinesIterator.next());
                if (!peekableLinesIterator.hasNext() || isNextConsecutive.test(lines, peekableLinesIterator.peek())) continue;
                return lines;
            }
            return lines.isEmpty() ? (List)state.endOfData() : lines;
        });
    }

    public static <T> Stream<List<T>> consecutive(Stream<T> lines, BiPredicate<List<T>, T> isNextConsecutive) {
        return Lines.consecutive(lines.iterator(), isNextConsecutive);
    }

    public static <K, V> Stream<Map.Entry<K, List<V>>> grouped(Iterable<V> lines, Function<V, K> getGroupKey, BiFunction<List<V>, V, GroupedLineType> getLineType) {
        return Lines.grouped(lines.iterator(), getGroupKey, getLineType);
    }

    public static <K, V> Stream<Map.Entry<K, List<V>>> grouped(Iterator<V> lines, Function<V, K> getGroupKey, BiFunction<List<V>, V, GroupedLineType> getLineType) {
        LinkedHashMap groups = new LinkedHashMap();
        return Iterators.stream(state -> {
            while (lines.hasNext()) {
                Object line = lines.next();
                Object groupKey = getGroupKey.apply(line);
                ArrayList groupOfCurrentLine = groups.computeIfAbsent(groupKey, key -> new ArrayList());
                GroupedLineType lineType = (GroupedLineType)((Object)((Object)getLineType.apply(groupOfCurrentLine, line)));
                if (lineType == GroupedLineType.END) {
                    groupOfCurrentLine.add(line);
                    return Maps.entry(groupKey, groups.remove(groupKey));
                }
                if (lineType == GroupedLineType.START && !groupOfCurrentLine.isEmpty()) {
                    groupOfCurrentLine = new ArrayList();
                    groupOfCurrentLine.add(line);
                    return Maps.entry(groupKey, groups.put(groupKey, groupOfCurrentLine));
                }
                groupOfCurrentLine.add(line);
            }
            if (groups.isEmpty()) {
                return (Map.Entry)state.endOfData();
            }
            Object groupKey = groups.keySet().iterator().next();
            return Maps.entry(groupKey, groups.remove(groupKey));
        });
    }

    public static <K, V> Stream<Map.Entry<K, List<V>>> grouped(Stream<V> lines, Function<V, K> getGroupKey, BiFunction<List<V>, V, GroupedLineType> getLineType) {
        return Lines.grouped(lines.iterator(), getGroupKey, getLineType);
    }

    public static Stream<String> lines(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return bufferedReader.lines();
    }

    public static List<String> lines(String value) {
        return Lines.lines(new StringReader(value)).collect(Collectors.toList());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Lines() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum GroupedLineType {
        START,
        MIDDLE,
        END;

    }
}

