/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.annotations.PackagePrivate;
import de.larssh.utils.text.Characters;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import lombok.Generated;

@PackagePrivate
final class NumericTextComparator
implements Comparator<String> {
    @PackagePrivate
    static final Comparator<String> COMPARATOR_CASE_INSENSITIVE = new NumericTextComparator(true);
    @PackagePrivate
    static final Comparator<String> COMPARATOR_CASE_SENSITIVE = new NumericTextComparator(false);
    private final boolean caseInsensitive;

    @Override
    public int compare(@Nullable String first, @Nullable String second) {
        if (first == null) {
            return second == null ? 0 : -1;
        }
        return second == null ? 1 : new NumericTextComparatorContext(first, second).compare();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private NumericTextComparator(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    private final class NumericTextComparatorContext {
        private final String first;
        private int firstIndex;
        private final int firstLength;
        private final String second;
        private int secondIndex;
        private final int secondLength;

        NumericTextComparatorContext(String first, String second) {
            this.first = first;
            this.firstLength = first.length();
            this.second = second;
            this.secondLength = second.length();
        }

        public int compare() {
            int compared;
            while (!this.isRest()) {
                if (!(this.isNumeric() ? (compared = this.compareSignedNumeric()) != 0 : (compared = this.compareText()) != 0)) continue;
                return compared;
            }
            compared = this.compareRest();
            if (compared != 0) {
                return compared;
            }
            return NumericTextComparator.this.isCaseInsensitive() ? this.first.compareToIgnoreCase(this.second) : this.first.compareTo(this.second);
        }

        private boolean isRest() {
            return this.firstIndex >= this.firstLength || this.secondIndex >= this.secondLength;
        }

        private boolean isNumeric() {
            return Characters.isAsciiDigit(this.first.charAt(this.firstIndex)) || Characters.isAsciiDigit(this.second.charAt(this.secondIndex)) || this.isSignedNumeric(this.first, this.firstLength, this.firstIndex) || this.isSignedNumeric(this.second, this.secondLength, this.secondIndex);
        }

        private boolean isSignedNumeric(String value, int length, int index) {
            char sign = value.charAt(index);
            if (sign != '-' && sign != '+' || index > 0 && !Characters.isAsciiWhitespace(value.charAt(index - 1)) || index + 1 >= length) {
                return false;
            }
            return Characters.isAsciiDigit(value.charAt(index + 1));
        }

        private int compareSignedNumeric() {
            boolean secondIsNegative;
            int firstSignedNumericLength = this.getNumericLength(this.first, this.firstLength, this.firstIndex);
            int secondSignedNumericLength = this.getNumericLength(this.second, this.secondLength, this.secondIndex);
            if (firstSignedNumericLength == 0 || secondSignedNumericLength == 0) {
                return firstSignedNumericLength == 0 ? 1 : -1;
            }
            boolean firstIsNegative = this.first.charAt(this.firstIndex) == '-';
            boolean bl = secondIsNegative = this.second.charAt(this.secondIndex) == '-';
            if (firstIsNegative != secondIsNegative) {
                return firstIsNegative ? -1 : 1;
            }
            int firstNumericLength = this.getDigitsLength(this.first, this.firstIndex, firstSignedNumericLength);
            int secondNumericLength = this.getDigitsLength(this.second, this.secondIndex, secondSignedNumericLength);
            this.firstIndex += firstSignedNumericLength;
            this.secondIndex += secondSignedNumericLength;
            return (firstIsNegative ? -1 : 1) * this.compareNumeric(firstNumericLength, secondNumericLength);
        }

        private int getNumericLength(String value, int length, int index) {
            int numericIndex = index;
            if (this.isSignedNumeric(value, length, numericIndex)) {
                numericIndex += 2;
            }
            while (numericIndex < length && Characters.isAsciiDigit(value.charAt(numericIndex))) {
                ++numericIndex;
            }
            return numericIndex - index;
        }

        private int getDigitsLength(String value, int index, int signedNumericLength) {
            for (int numericIndex = 0; numericIndex < signedNumericLength; ++numericIndex) {
                char character = value.charAt(index + numericIndex);
                if (character == '0' || character == '-' || character == '+') continue;
                return signedNumericLength - numericIndex;
            }
            return 1;
        }

        private int compareNumeric(int firstNumericLength, int secondNumericLength) {
            if (firstNumericLength != secondNumericLength) {
                return firstNumericLength - secondNumericLength;
            }
            for (int numericIndex = firstNumericLength; numericIndex > 0; --numericIndex) {
                char secondNumericCharacter;
                char firstNumericCharacter = this.first.charAt(this.firstIndex - numericIndex);
                if (firstNumericCharacter == (secondNumericCharacter = this.second.charAt(this.secondIndex - numericIndex))) continue;
                return firstNumericCharacter - secondNumericCharacter;
            }
            return 0;
        }

        private int compareText() {
            char firstCharacter = this.first.charAt(this.firstIndex);
            char secondCharacter = this.second.charAt(this.secondIndex);
            ++this.firstIndex;
            ++this.secondIndex;
            return NumericTextComparator.this.isCaseInsensitive() ? Characters.compareIgnoreCase(firstCharacter, secondCharacter) : firstCharacter - secondCharacter;
        }

        private int compareRest() {
            return this.firstLength - this.firstIndex - (this.secondLength - this.secondIndex);
        }
    }
}

