/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class Patterns {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("[\\\\\\[\\].^$?*+{}|()]");

    public static Optional<Matcher> find(Pattern pattern, CharSequence input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find() ? Optional.of(matcher) : Optional.empty();
    }

    public static Optional<Matcher> matches(Pattern pattern, CharSequence input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.matches() ? Optional.of(matcher) : Optional.empty();
    }

    public static String quote(CharSequence input) {
        return Strings.replaceAll(input, QUOTE_PATTERN, "\\\\$0").replace("\t", "\\t").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\u0007", "\\a").replace("\u001b", "\\e");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Patterns() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

