/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

public class SentenceFormatter {
    private static final String SEPARATOR_KEBAB_CASE = "-";
    private static final String SEPARATOR_SNAKE_CASE = "_";
    private static final String SEPARATOR_WHITE_SPACE = " ";
    public static final SentenceFormatter LOWER_CAMEL_CASE = new SentenceFormatter(Strings::toLowerCaseNeutral, "", Strings::toTitleCaseNeutral);
    public static final SentenceFormatter LOWER_KEBAB_CASE = new SentenceFormatter(Strings::toLowerCaseNeutral, "-", Strings::toLowerCaseNeutral);
    public static final SentenceFormatter LOWER_SNAKE_CASE = new SentenceFormatter(Strings::toLowerCaseNeutral, "_", Strings::toLowerCaseNeutral);
    public static final SentenceFormatter LOWER_WHITE_SPACE = new SentenceFormatter(Strings::toTitleCaseNeutral, " ", Strings::toLowerCaseNeutral);
    public static final SentenceFormatter UPPER_CAMEL_CASE = new SentenceFormatter(Strings::toTitleCaseNeutral, "", Strings::toTitleCaseNeutral);
    public static final SentenceFormatter UPPER_KEBAB_CASE = new SentenceFormatter(Strings::toUpperCaseNeutral, "-", Strings::toUpperCaseNeutral);
    public static final SentenceFormatter UPPER_SNAKE_CASE = new SentenceFormatter(Strings::toUpperCaseNeutral, "_", Strings::toUpperCaseNeutral);
    public static final SentenceFormatter UPPER_WHITE_SPACE = new SentenceFormatter(Strings::toTitleCaseNeutral, " ", Strings::toTitleCaseNeutral);
    private final Function<String, String> convertFirstWord;
    private final String separator;
    private final Function<String, String> convertSubsequentWords;

    public String format(String ... words) {
        return this.format(Arrays.asList(words));
    }

    public String format(List<String> words) {
        if (words.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getConvertFirstWord().apply(words.get(0)));
        int size = words.size();
        for (int index = 1; index < size; ++index) {
            builder.append(this.getSeparator());
            builder.append(this.getConvertSubsequentWords().apply(words.get(index)));
        }
        return builder.toString();
    }

    public List<String> parse(String sentence) {
        if (sentence.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.getSeparator().isEmpty()) {
            return this.splitByTitleCharacters(sentence);
        }
        return this.splitBySeparator(sentence);
    }

    private List<String> splitBySeparator(String sentence) {
        int sentenceLength = sentence.length();
        int separatorLength = this.getSeparator().length();
        int length = sentenceLength - separatorLength;
        int beginIndex = 0;
        ArrayList<String> words = new ArrayList<String>();
        for (int index = 0; index < length; ++index) {
            if (!sentence.regionMatches(index, this.getSeparator(), 0, separatorLength)) continue;
            words.add(sentence.substring(beginIndex, index));
            beginIndex = index + separatorLength;
        }
        words.add(sentence.substring(beginIndex, sentenceLength));
        return words;
    }

    private List<String> splitByTitleCharacters(String sentence) {
        int length = sentence.length();
        int beginIndex = 0;
        ArrayList<String> words = new ArrayList<String>();
        for (int index = 1; index < length; ++index) {
            if (!Character.isUpperCase(sentence.charAt(index))) continue;
            words.add(sentence.substring(beginIndex, index));
            beginIndex = index;
        }
        words.add(sentence.substring(beginIndex, length));
        return words;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Function<String, String> getConvertFirstWord() {
        return this.convertFirstWord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Function<String, String> getConvertSubsequentWords() {
        return this.convertSubsequentWords;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SentenceFormatter(Function<String, String> convertFirstWord, String separator, Function<String, String> convertSubsequentWords) {
        this.convertFirstWord = convertFirstWord;
        this.separator = separator;
        this.convertSubsequentWords = convertSubsequentWords;
    }
}

