/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.text;

import de.larssh.utils.text.Csv;
import de.larssh.utils.text.CsvParser;
import de.larssh.utils.text.ParseException;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;

public final class StringConverters {
    public static String decodeBase64(String value) {
        return new String(Base64.getDecoder().decode(value), Strings.DEFAULT_CHARSET);
    }

    public static String decodeBase64Mime(String value) {
        return new String(Base64.getMimeDecoder().decode(value), Strings.DEFAULT_CHARSET);
    }

    public static String decodeBase64Url(String value) {
        return new String(Base64.getUrlDecoder().decode(value), Strings.DEFAULT_CHARSET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exception, that should never be thrown at all")
    public static Csv decodeCsv(String data, char separator, char escaper) {
        try (StringReader reader = new StringReader(data);){
            Csv csv = Csv.parse(reader, separator, escaper);
            return csv;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exception, that should never be thrown at all")
    public static String decodeUrl(String value) throws ParseException {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e, "Failed decoding URL.", new Object[0]);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String encodeBase64(String value) {
        return new String(Base64.getEncoder().encode(value.getBytes(Strings.DEFAULT_CHARSET)), Strings.DEFAULT_CHARSET);
    }

    public static String encodeBase64Mime(String value) {
        return new String(Base64.getMimeEncoder().encode(value.getBytes(Strings.DEFAULT_CHARSET)), Strings.DEFAULT_CHARSET);
    }

    public static String encodeBase64Url(String value) {
        return new String(Base64.getUrlEncoder().encode(value.getBytes(Strings.DEFAULT_CHARSET)), Strings.DEFAULT_CHARSET);
    }

    public static String encodeCsv(Collection<? extends Collection<String>> data, char separator, char escaper) {
        return data.stream().map(row -> StringConverters.encodeCsvRow(row, separator, escaper)).collect(Collectors.joining(Strings.NEW_LINE));
    }

    public static String encodeCsvRow(Collection<? extends String> values, char separator, char escaper) {
        return values.stream().map(value -> StringConverters.encodeCsvValue(value, separator, escaper)).collect(Collectors.joining(Character.toString(separator)));
    }

    public static String encodeCsvValue(String value, char separator, char escaper) {
        int index;
        CsvParser.assertCsvInput(separator, escaper);
        int length = value.length();
        boolean needsEscaping = false;
        for (index = 0; index < length && !needsEscaping; ++index) {
            char character = value.charAt(index);
            if (character == escaper) {
                needsEscaping = true;
                --index;
                continue;
            }
            if (character != separator && character != '\r' && character != '\n') continue;
            needsEscaping = true;
        }
        if (!needsEscaping) {
            return value;
        }
        StringBuilder builder = new StringBuilder(length + 2);
        builder.append(escaper);
        if (index > 0) {
            builder.append(value, 0, index);
        }
        while (index < length) {
            char character = value.charAt(index);
            if (character == escaper) {
                builder.append(escaper);
            }
            builder.append(character);
            ++index;
        }
        return builder.append(escaper).toString();
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="converting checked to unchecked exception, that should never be thrown at all")
    public static String encodeUrl(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private StringConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

