/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.time;

import de.larssh.utils.text.Strings;
import de.larssh.utils.time.CloseableStopwatch;
import de.larssh.utils.time.Stopwatch;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class LoggingStopwatch
extends CloseableStopwatch {
    private final Consumer<? super LoggingStopwatch> logger;
    private final String name;
    private final Object lock = new Object();

    public static LoggingStopwatch earlyWithString(String name, Consumer<String> logger) {
        return LoggingStopwatch.early(name, supplier -> logger.accept((String)supplier.get()));
    }

    public static LoggingStopwatch lateWithString(String name, Consumer<String> logger) {
        return LoggingStopwatch.late(name, supplier -> logger.accept((String)supplier.get()));
    }

    public static LoggingStopwatch early(String name, Consumer<Supplier<String>> logger) {
        return new LoggingStopwatch(name, stopwatch -> StringLoggingStopwatchMode.EARLY.getLogger().accept((LoggingStopwatch)stopwatch, logger));
    }

    public static LoggingStopwatch late(String name, Consumer<Supplier<String>> logger) {
        return new LoggingStopwatch(name, stopwatch -> StringLoggingStopwatchMode.LATE.getLogger().accept((LoggingStopwatch)stopwatch, logger));
    }

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="made sure to call accept after initializing all fields")
    public LoggingStopwatch(String name, Consumer<? super LoggingStopwatch> logger) {
        this.logger = logger;
        this.name = name;
        logger.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stopwatch.Checkpoint checkpoint(String name) {
        Object object = this.lock;
        synchronized (object) {
            Stopwatch.Checkpoint checkpoint = super.checkpoint(name);
            this.logger.accept(this);
            return checkpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStopped()) {
                super.close();
                this.logger.accept(this);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Consumer<? super LoggingStopwatch> getLogger() {
        return this.logger;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LoggingStopwatch(super=" + super.toString() + ", logger=" + this.getLogger() + ", name=" + this.getName() + ")";
    }

    private static enum StringLoggingStopwatchMode {
        EARLY((stopwatch, logger) -> {
            Optional<Stopwatch.Checkpoint> lastCheckpoint = stopwatch.getLastCheckpoint();
            if (stopwatch.isStopped()) {
                StringLoggingStopwatchMode.logStopwatchStopped(stopwatch, logger);
            } else if (lastCheckpoint.isPresent()) {
                StringLoggingStopwatchMode.logCheckpoint(lastCheckpoint.get(), logger);
            } else {
                StringLoggingStopwatchMode.logStopwatchStarted(stopwatch, logger);
            }
        }),
        LATE((stopwatch, logger) -> {
            if (stopwatch.isStopped()) {
                StringLoggingStopwatchMode.logStopwatchStarted(stopwatch, logger);
                stopwatch.stream().forEach(checkpoint -> StringLoggingStopwatchMode.logCheckpoint(checkpoint, logger));
                StringLoggingStopwatchMode.logStopwatchStopped(stopwatch, logger);
            }
        });

        private final BiConsumer<LoggingStopwatch, Consumer<Supplier<String>>> logger;

        private static String formatDuration(Duration duration) {
            return duration.toString().substring(2);
        }

        private static void logCheckpoint(Stopwatch.Checkpoint checkpoint, Consumer<Supplier<String>> logger) {
            logger.accept(() -> Strings.format("Period took %s. Checkpoint \"%s\" reached at %s after %s.", StringLoggingStopwatchMode.formatDuration(checkpoint.sincePrevious()), checkpoint.getName(), checkpoint.getInstant(), StringLoggingStopwatchMode.formatDuration(checkpoint.sinceStart())));
        }

        private static void logStopwatchStarted(LoggingStopwatch stopwatch, Consumer<Supplier<String>> logger) {
            logger.accept(() -> Strings.format("Stopwatch \"%s\" started at %s.", stopwatch.getName(), stopwatch.getStartInstant()));
        }

        private static void logStopwatchStopped(LoggingStopwatch stopwatch, Consumer<Supplier<String>> logger) {
            String lastPeriod = stopwatch.getLastCheckpoint().isPresent() ? Strings.format("Period took %s. ", StringLoggingStopwatchMode.formatDuration(stopwatch.sinceLast())) : "";
            logger.accept(() -> Strings.format("%sStopwatch \"%s\" stopped at %s after %s.", lastPeriod, stopwatch.getName(), stopwatch.getStopInstant(), StringLoggingStopwatchMode.formatDuration(stopwatch.sinceStart())));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BiConsumer<LoggingStopwatch, Consumer<Supplier<String>>> getLogger() {
            return this.logger;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private StringLoggingStopwatchMode(BiConsumer<LoggingStopwatch, Consumer<Supplier<String>>> logger) {
            this.logger = logger;
        }
    }
}

