/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.utils.xml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.Function;
import javax.xml.transform.Transformer;
import lombok.Generated;

public class TransformerOutputProperty<T> {
    private static final String BOOLEAN_VALUE_FALSE = "no";
    private static final String BOOLEAN_VALUE_TRUE = "yes";
    private final String name;
    private final Function<T, String> serializer;
    private final Function<String, T> deserializer;

    public static TransformerOutputProperty<Boolean> booleanOutputProperty(String name) {
        return new TransformerOutputProperty<Boolean>(name, value -> value != false ? BOOLEAN_VALUE_TRUE : BOOLEAN_VALUE_FALSE, BOOLEAN_VALUE_TRUE::equalsIgnoreCase);
    }

    public static TransformerOutputProperty<Class<?>> classOutputProperty(String name) {
        return new TransformerOutputProperty(name, Class::getName, value -> {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public static TransformerOutputProperty<Integer> integerOutputProperty(String name) {
        return new TransformerOutputProperty<Integer>(name, value -> Integer.toString(value), Integer::parseInt);
    }

    public static TransformerOutputProperty<String> stringOutputProperty(String name) {
        return new TransformerOutputProperty<String>(name, Function.identity(), Function.identity());
    }

    public T get(Transformer transformer) {
        return this.getDeserializer().apply(transformer.getOutputProperty(this.getName()));
    }

    public void set(Transformer transformer, T value) {
        transformer.setOutputProperty(this.getName(), this.getSerializer().apply(value));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TransformerOutputProperty(String name, Function<T, String> serializer, Function<String, T> deserializer) {
        this.name = name;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected Function<T, String> getSerializer() {
        return this.serializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected Function<String, T> getDeserializer() {
        return this.deserializer;
    }
}

