/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.env.Environment;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;

public class StacktraceImage {
    private final String msg;
    private final Throwable throwable;
    private final int width;
    private final int height;

    public StacktraceImage(String msg, Throwable t, Environment environment) {
        this.msg = msg;
        this.throwable = t;
        this.width = 8 * environment.getDPI();
        this.height = 11 * environment.getDPI();
    }

    public ImageWithDimension getBlankImage() {
        return new ImageWithDimension(new BufferedImage(this.width, this.height, 1), this.width, this.height);
    }

    public ImageWithDimension getImage() {
        BufferedImage errorImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics = errorImage.createGraphics();
        graphics.setFont(new Font("SansSerif", 0, 24));
        int nextY = this.drawString(graphics, this.msg, 100, 100);
        StringWriter sw = new StringWriter();
        this.throwable.printStackTrace(new PrintWriter(sw));
        this.drawString(graphics, sw.toString(), 100, nextY += graphics.getFontMetrics().getHeight());
        graphics.dispose();
        return new ImageWithDimension(errorImage, errorImage.getWidth(), errorImage.getHeight());
    }

    private int drawString(Graphics g, String text, int x, int y) {
        int lineHeight = g.getFontMetrics().getHeight();
        for (String line : text.split("\n")) {
            g.drawString(line, x, y += lineHeight);
        }
        return y;
    }
}

