/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import de.redsix.pdfcompare.CompareResultWithExpectedAndActual;
import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.cli.CliArguments;
import de.redsix.pdfcompare.env.DefaultEnvironment;
import de.redsix.pdfcompare.env.Environment;
import de.redsix.pdfcompare.ui.ExclusionItemPanel;
import de.redsix.pdfcompare.ui.ExclusionsPanel;
import de.redsix.pdfcompare.ui.ImagePanel;
import de.redsix.pdfcompare.ui.ViewModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;

public class Display {
    private final JFrame frame = new JFrame();
    private ViewModel viewModel = new ViewModel(new CompareResultWithExpectedAndActual());
    private final ImagePanel leftPanel = new ImagePanel(this.viewModel.getLeftImage());
    private final ImagePanel resultPanel = new ImagePanel(this.viewModel.getDiffImage());
    private final JToggleButton expectedButton = new JToggleButton("Expected");
    private ExclusionsPanel exclusionsPanel;
    private boolean showExclusions = false;
    private PageArea dragArea;
    private final Environment environment = DefaultEnvironment.create();
    private final Exclusions exclusions = new Exclusions(this.environment);
    private static final Color SHADE_BORDER = new Color(7372944);
    private static final Color SHADE = new Color(0x70606000, true);
    private static final Color SHADE_HIGHLIGHT = new Color(-1600085761, true);

    public void init(CliArguments cliArguments) {
        this.init();
        if (cliArguments.hasFileArguments()) {
            try {
                cliArguments.getExclusionsFile().ifPresent(ef -> {
                    this.exclusions.readExclusions((String)ef);
                    this.exclusionsPanel.openExclusionFile(new File((String)ef));
                });
                this.openFiles(new File(cliArguments.getExpectedFile().get()), cliArguments.getExpectedPassword(), new File(cliArguments.getActualFile().get()), cliArguments.getActualPassword(), cliArguments.getExclusionsFile());
            }
            catch (IOException ex) {
                Display.displayExceptionDialog(this.frame, ex);
            }
        }
    }

    public void init() {
        String title = "PDF Compare Studio";
        this.frame.setTitle("PDF Compare Studio");
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/pdfcomparestudio16.png")));
        icons.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/pdfcomparestudio40.png")));
        this.frame.setIconImages(icons);
        this.frame.setDefaultCloseOperation(2);
        BorderLayout borderLayout = new BorderLayout();
        this.frame.setLayout(borderLayout);
        this.frame.setMinimumSize(new Dimension(400, 200));
        Rectangle screenBounds = Display.getDefaultScreenBounds();
        this.frame.setSize(Math.min(screenBounds.width, 1700), Math.min(screenBounds.height, 1000));
        this.frame.setLocation(screenBounds.x, screenBounds.y);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        this.frame.add((Component)toolBar, "First");
        JScrollPane expectedScrollPane = new JScrollPane(this.leftPanel);
        expectedScrollPane.setMinimumSize(new Dimension(200, 200));
        JScrollPane actualScrollPane = new JScrollPane(this.resultPanel);
        actualScrollPane.setMinimumSize(new Dimension(200, 200));
        actualScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Display.this.resultPanel.setViewSize(e.getComponent().getSize());
                super.componentResized(e);
            }
        });
        expectedScrollPane.getVerticalScrollBar().setModel(actualScrollPane.getVerticalScrollBar().getModel());
        expectedScrollPane.getHorizontalScrollBar().setModel(actualScrollPane.getHorizontalScrollBar().getModel());
        expectedScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Display.this.leftPanel.setViewSize(e.getComponent().getSize());
                super.componentResized(e);
            }
        });
        JSplitPane splitPane = new JSplitPane(1, expectedScrollPane, actualScrollPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        this.frame.add((Component)splitPane, "Center");
        this.exclusionsPanel = new ExclusionsPanel(this, this.environment);
        this.exclusionsPanel.setVisible(this.showExclusions);
        this.frame.add((Component)this.exclusionsPanel, "East");
        Display.addToolBarButton(toolBar, "Open...", event -> {
            JFileChooser fileChooser = new JFileChooser();
            try {
                if (fileChooser.showDialog(this.frame, "Open expected PDF") == 0) {
                    File expectedFile = fileChooser.getSelectedFile();
                    Optional<String> passwordForExpectedFile = Display.askForPasswordIfNeeded(expectedFile);
                    if (fileChooser.showDialog(this.frame, "Open actual PDF") == 0) {
                        File actualFile = fileChooser.getSelectedFile();
                        Optional<String> passwordForActualFile = Display.askForPasswordIfNeeded(actualFile);
                        this.openFiles(expectedFile, passwordForExpectedFile, actualFile, passwordForActualFile, Optional.empty());
                    }
                }
            }
            catch (IOException ex) {
                Display.displayExceptionDialog(this.frame, ex);
            }
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Page -", event -> {
            if (this.viewModel.decreasePage()) {
                this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
                this.resultPanel.setImage(this.applyExclusions(this.viewModel.getDiffImage()));
            }
        });
        Display.addToolBarButton(toolBar, "Page +", event -> {
            if (this.viewModel.increasePage()) {
                this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
                this.resultPanel.setImage(this.applyExclusions(this.viewModel.getDiffImage()));
            }
        });
        toolBar.addSeparator();
        JToggleButton pageZoomButton = new JToggleButton("Zoom Page");
        pageZoomButton.setSelected(true);
        pageZoomButton.setFocusable(false);
        pageZoomButton.addActionListener(event -> {
            this.leftPanel.zoomPage();
            this.resultPanel.zoomPage();
        });
        Display.addToolBarButton(toolBar, "Zoom -", event -> {
            pageZoomButton.setSelected(false);
            this.leftPanel.decreaseZoom();
            this.resultPanel.decreaseZoom();
        });
        Display.addToolBarButton(toolBar, "Zoom +", event -> {
            pageZoomButton.setSelected(false);
            this.leftPanel.increaseZoom();
            this.resultPanel.increaseZoom();
        });
        toolBar.add(pageZoomButton);
        Display.addToolBarButton(toolBar, "Zoom 100%", event -> {
            pageZoomButton.setSelected(false);
            this.leftPanel.zoom100();
            this.resultPanel.zoom100();
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Center Split", event -> {
            splitPane.setDividerLocation(0.5);
            splitPane.revalidate();
        });
        toolBar.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.expectedButton.setSelected(true);
        this.expectedButton.setFocusable(false);
        this.expectedButton.addActionListener(event -> {
            this.viewModel.showExpected();
            this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
        });
        toolBar.add(this.expectedButton);
        buttonGroup.add(this.expectedButton);
        JToggleButton actualButton = new JToggleButton("Actual");
        actualButton.setFocusable(false);
        actualButton.addActionListener(event -> {
            this.viewModel.showActual();
            this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
        });
        toolBar.add(actualButton);
        buttonGroup.add(actualButton);
        toolBar.addSeparator();
        MouseAdapter mouseListener = new MouseAdapter(){
            private boolean dragging = false;
            private Point startPoint;

            @Override
            public void mouseClicked(MouseEvent e) {
                double zoom = Display.this.leftPanel.getZoomFactor();
                ExclusionItemPanel item = Display.this.exclusionsPanel.getItemAt(Display.this.viewModel.getPageToShow() + 1, (int)((double)e.getX() / zoom), (int)((double)e.getY() / zoom));
                if (item != null) {
                    Display.this.exclusionsPanel.setSelectedItem(item);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.startPoint = e.getPoint();
                this.dragging = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.dragging) {
                    Point endPoint = e.getPoint();
                    double d = Point2D.distance(this.startPoint.x, this.startPoint.y, endPoint.x, endPoint.y);
                    if (d > 7.0) {
                        int pageNumber = Display.this.viewModel.getPageToShow();
                        PageArea pageArea = this.getPageArea(pageNumber, endPoint);
                        Display.this.exclusionsPanel.addExclusion(pageArea);
                        ExclusionItemPanel item = Display.this.exclusionsPanel.getItemForArea(pageArea);
                        Display.this.exclusionsPanel.setSelectedItem(item);
                    }
                    this.dragging = false;
                    this.startPoint = null;
                    Display.this.dragArea = null;
                    Display.this.redrawImages();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.dragging) {
                    int pageNumber = Display.this.viewModel.getPageToShow();
                    Point endPoint = e.getPoint();
                    Display.this.dragArea = this.getPageArea(pageNumber, endPoint);
                    Display.this.redrawImages();
                }
            }

            private PageArea getPageArea(int pageNumber, Point endPoint) {
                double zoom = Display.this.leftPanel.getZoomFactor();
                int x1 = (int)Math.min((double)this.startPoint.x / zoom, (double)endPoint.x / zoom);
                int y1 = (int)Math.min((double)this.startPoint.y / zoom, (double)endPoint.y / zoom);
                int x2 = (int)Math.max((double)this.startPoint.x / zoom, (double)endPoint.x / zoom);
                int y2 = (int)Math.max((double)this.startPoint.y / zoom, (double)endPoint.y / zoom);
                return new PageArea(pageNumber + 1, x1, y1, x2, y2);
            }
        };
        MouseWheelListener mouseWheelListener = mouseWheelEvent -> {
            BoundedRangeModel horizontalModel = actualScrollPane.getHorizontalScrollBar().getModel();
            BoundedRangeModel verticalModel = actualScrollPane.getVerticalScrollBar().getModel();
            double horizontalOffset = horizontalModel.getValue();
            double verticalOffset = verticalModel.getValue();
            double horizontalExtent = horizontalModel.getExtent();
            double verticalExtent = verticalModel.getExtent();
            double zoomBefore = this.leftPanel.getZoomFactor();
            if (mouseWheelEvent.getWheelRotation() > 0) {
                this.leftPanel.decreaseZoom();
                this.resultPanel.decreaseZoom();
                double zoomAfter = this.leftPanel.getZoomFactor();
                int horizontalValue = (int)((horizontalOffset + horizontalExtent / 2.0) * zoomAfter / zoomBefore - horizontalExtent / 2.0);
                int verticalValue = (int)((verticalOffset + verticalExtent / 2.0) * zoomAfter / zoomBefore - verticalExtent / 2.0);
                horizontalModel.setValue(horizontalValue);
                verticalModel.setValue(verticalValue);
            } else {
                this.leftPanel.increaseZoom();
                this.resultPanel.increaseZoom();
                Point mousePoint = mouseWheelEvent.getPoint();
                double zoomAfter = this.leftPanel.getZoomFactor();
                int horizontalValue = (int)((double)mousePoint.x * zoomAfter / zoomBefore - horizontalExtent / 2.0);
                int verticalValue = (int)((double)mousePoint.y * zoomAfter / zoomBefore - verticalExtent / 2.0);
                SwingUtilities.invokeLater(() -> {
                    horizontalModel.setValue(horizontalValue);
                    verticalModel.setValue(verticalValue);
                });
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEvent -> {
            if (keyEvent.getKeyCode() == 17) {
                if (keyEvent.getID() == 401) {
                    this.leftPanel.addMouseWheelListener(mouseWheelListener);
                    this.resultPanel.addMouseWheelListener(mouseWheelListener);
                } else if (keyEvent.getID() == 402) {
                    this.leftPanel.removeMouseWheelListener(mouseWheelListener);
                    this.resultPanel.removeMouseWheelListener(mouseWheelListener);
                }
            }
            return false;
        });
        JToggleButton exclusionMode = new JToggleButton("Exclusions");
        exclusionMode.setFocusable(false);
        exclusionMode.addActionListener(event -> {
            if (exclusionMode.isSelected()) {
                this.leftPanel.addMouseListener(mouseListener);
                this.leftPanel.addMouseMotionListener(mouseListener);
                this.resultPanel.addMouseListener(mouseListener);
                this.resultPanel.addMouseMotionListener(mouseListener);
                this.leftPanel.setCursor(Cursor.getPredefinedCursor(1));
                this.showExclusions = true;
            } else {
                this.leftPanel.removeMouseListener(mouseListener);
                this.leftPanel.removeMouseMotionListener(mouseListener);
                this.resultPanel.removeMouseListener(mouseListener);
                this.resultPanel.removeMouseMotionListener(mouseListener);
                this.leftPanel.setCursor(Cursor.getPredefinedCursor(0));
                this.showExclusions = false;
            }
            this.exclusionsPanel.setVisible(this.showExclusions);
            this.redrawImages();
            this.frame.setTitle("PDF Compare Studio");
        });
        toolBar.add(exclusionMode);
        this.frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFiles(File expectedFile, Optional<String> passwordForExpectedFile, File actualFile, Optional<String> passwordForActualFile, Optional<String> exclusions) throws IOException {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            PdfComparator<CompareResultWithExpectedAndActual> pdfComparator = new PdfComparator<CompareResultWithExpectedAndActual>(expectedFile, actualFile, new CompareResultWithExpectedAndActual());
            passwordForExpectedFile.ifPresent(pdfComparator::withExpectedPassword);
            passwordForActualFile.ifPresent(pdfComparator::withActualPassword);
            exclusions.ifPresent(pdfComparator::withIgnore);
            CompareResultWithExpectedAndActual compareResult = pdfComparator.compare();
            this.viewModel = new ViewModel(compareResult);
            this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
            this.resultPanel.setImage(this.applyExclusions(this.viewModel.getDiffImage()));
            if (compareResult.isEqual()) {
                JOptionPane.showMessageDialog(this.frame, "The compared documents are identical.");
            }
            this.expectedButton.setSelected(true);
        }
        finally {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static void displayExceptionDialog(JFrame frame, IOException ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        JTextArea textArea = new JTextArea("An unexpected error has occurred: " + ex.getMessage() + "\n\n" + stringWriter);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(900, 700));
        JOptionPane.showMessageDialog(frame, scrollPane);
    }

    private static void addToolBarButton(JToolBar toolBar, String label, ActionListener actionListener) {
        JButton button = new JButton(label);
        button.setFocusable(false);
        button.addActionListener(actionListener);
        toolBar.add(button);
    }

    private static Rectangle getDefaultScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }

    private static Optional<String> askForPasswordIfNeeded(File file) throws IOException {
        if (!Display.isInvalidPassword(file, "")) {
            return Optional.empty();
        }
        JPasswordField passwordField = new JPasswordField(20);
        JLabel label = new JLabel("Enter password: ");
        label.setLabelFor(passwordField);
        JPanel textPane = new JPanel(new FlowLayout(4));
        textPane.add(label);
        textPane.add(passwordField);
        JOptionPane.showMessageDialog(null, textPane, "PDF is encrypted", 1);
        label.setText("Password was invalid. Enter password: ");
        while (Display.isInvalidPassword(file, String.valueOf(passwordField.getPassword()))) {
            passwordField.setText("");
            JOptionPane.showMessageDialog(null, textPane, "PDF is encrypted", 0);
        }
        return Optional.of(String.valueOf(passwordField.getPassword()));
    }

    private static boolean isInvalidPassword(File file, String password) throws IOException {
        try {
            Loader.loadPDF((File)file, (String)password).close();
        }
        catch (InvalidPasswordException e) {
            return true;
        }
        return false;
    }

    public void redrawImages() {
        this.leftPanel.setImage(this.applyExclusions(this.viewModel.getLeftImage()));
        this.resultPanel.setImage(this.applyExclusions(this.viewModel.getDiffImage()));
    }

    public void showPageArea(PageArea pageArea) {
        int pageNo = pageArea.getPage();
        this.viewModel.setPageToShow(pageNo - 1);
        this.redrawImages();
        if (pageArea.getX1() != -1) {
            double zoom = this.leftPanel.getZoomFactor();
            Rectangle rect = new Rectangle((int)((double)pageArea.getX1() * zoom), (int)((double)pageArea.getY1() * zoom), (int)((double)(pageArea.getX2() - pageArea.getX1()) * zoom), (int)((double)(pageArea.getY2() - pageArea.getY1()) * zoom));
            this.leftPanel.scrollRectToVisible(rect);
            this.frame.repaint();
        }
    }

    public BufferedImage applyExclusions(BufferedImage image) {
        if (image == null) {
            return null;
        }
        if (!this.showExclusions) {
            return image;
        }
        int pageNo = this.viewModel.getPageToShow();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        this.exclusionsPanel.getExclusions().forPage(pageNo + 1).getExclusions().forEach(pa -> {
            if (!pa.hasCoordinates()) {
                g.setColor(this.exclusionsPanel.isSelected((PageArea)pa) ? SHADE_HIGHLIGHT : SHADE);
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.setColor(SHADE_BORDER);
                g.drawRect(0, 0, image.getWidth(), image.getHeight());
            } else {
                g.setColor(this.exclusionsPanel.isSelected((PageArea)pa) ? SHADE_HIGHLIGHT : SHADE);
                g.fillRect(pa.getX1(), pa.getY1(), pa.getX2() - pa.getX1(), pa.getY2() - pa.getY1());
                g.setColor(SHADE_BORDER);
                g.drawRect(pa.getX1(), pa.getY1(), pa.getX2() - pa.getX1(), pa.getY2() - pa.getY1());
                if (this.dragArea == null && this.exclusionsPanel.isSelected((PageArea)pa)) {
                    ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 20.0f}, 5.0f));
                    g.drawLine(0, pa.getY1(), image.getWidth(), pa.getY1());
                    g.drawLine(0, pa.getY2(), image.getWidth(), pa.getY2());
                    g.drawLine(pa.getX1(), 0, pa.getX1(), image.getHeight());
                    g.drawLine(pa.getX2(), 0, pa.getX2(), image.getHeight());
                    ((Graphics2D)g).setStroke(new BasicStroke());
                }
            }
        });
        if (this.dragArea != null) {
            g.setColor(SHADE_HIGHLIGHT);
            g.fillRect(this.dragArea.getX1(), this.dragArea.getY1(), this.dragArea.getX2() - this.dragArea.getX1(), this.dragArea.getY2() - this.dragArea.getY1());
            g.setColor(SHADE_BORDER);
            g.drawRect(this.dragArea.getX1(), this.dragArea.getY1(), this.dragArea.getX2() - this.dragArea.getX1(), this.dragArea.getY2() - this.dragArea.getY1());
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 20.0f}, 5.0f));
            g.drawLine(0, this.dragArea.getY1(), image.getWidth(), this.dragArea.getY1());
            g.drawLine(0, this.dragArea.getY2(), image.getWidth(), this.dragArea.getY2());
            g.drawLine(this.dragArea.getX1(), 0, this.dragArea.getX1(), image.getHeight());
            g.drawLine(this.dragArea.getX2(), 0, this.dragArea.getX2(), image.getHeight());
            ((Graphics2D)g).setStroke(new BasicStroke());
        }
        return bufferedImage;
    }

    public int getPageNumber() {
        return this.viewModel.getPageToShow() + 1;
    }

    public Exclusions getExclusions() {
        return this.exclusions;
    }
}

