/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DPaintApplier;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class PdfBoxGraphics2DPaintApplier
implements IPdfBoxGraphics2DPaintApplier {
    private ExtGStateCache extGStateCache = new ExtGStateCache();
    private PDShadingCache shadingCache = new PDShadingCache();

    @Override
    public PDShading applyPaint(Paint paint, PDPageContentStream contentStream, AffineTransform tf, IPdfBoxGraphics2DPaintApplier.IPaintEnv env) throws IOException {
        PaintApplierState state = new PaintApplierState();
        state.document = env.getDocument();
        state.resources = env.getResources();
        state.contentStream = contentStream;
        state.colorMapper = env.getColorMapper();
        state.imageEncoder = env.getImageEncoder();
        state.composite = env.getComposite();
        state.pdExtendedGraphicsState = null;
        state.env = env;
        state.tf = tf;
        PDShading shading = this.applyPaint(paint, state);
        if (state.pdExtendedGraphicsState != null) {
            contentStream.setGraphicsStateParameters(this.extGStateCache.makeUnqiue(state.pdExtendedGraphicsState));
        }
        return shading;
    }

    protected void applyAsStrokingColor(Color color, PaintApplierState state) throws IOException {
        PDPageContentStream contentStream = state.contentStream;
        IPdfBoxGraphics2DColorMapper colorMapper = state.colorMapper;
        contentStream.setStrokingColor(colorMapper.mapColor(contentStream, color));
        contentStream.setNonStrokingColor(colorMapper.mapColor(contentStream, color));
        int alpha = color.getAlpha();
        if (alpha < 255) {
            state.ensureExtendedState();
            Float strokingAlphaConstant = state.pdExtendedGraphicsState.getStrokingAlphaConstant();
            if (strokingAlphaConstant == null) {
                strokingAlphaConstant = Float.valueOf(1.0f);
            }
            state.pdExtendedGraphicsState.setStrokingAlphaConstant(Float.valueOf(strokingAlphaConstant.floatValue() * ((float)alpha / 255.0f)));
            Float nonStrokingAlphaConstant = state.pdExtendedGraphicsState.getNonStrokingAlphaConstant();
            if (nonStrokingAlphaConstant == null) {
                nonStrokingAlphaConstant = Float.valueOf(1.0f);
            }
            state.pdExtendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(nonStrokingAlphaConstant.floatValue() * ((float)alpha / 255.0f)));
        }
    }

    private PDShading applyPaint(Paint paint, PaintApplierState state) throws IOException {
        this.applyComposite(state);
        String simpleName = paint.getClass().getSimpleName();
        if (paint instanceof Color) {
            this.applyAsStrokingColor((Color)paint, state);
        } else {
            if (simpleName.equals("LinearGradientPaint")) {
                return this.shadingCache.makeUnqiue(this.buildLinearGradientShading(paint, state));
            }
            if (simpleName.equals("RadialGradientPaint")) {
                return this.shadingCache.makeUnqiue(this.buildRadialGradientShading(paint, state));
            }
            if (simpleName.equals("PatternPaint")) {
                this.applyPatternPaint(paint, state);
            } else {
                if (paint instanceof GradientPaint) {
                    return this.shadingCache.makeUnqiue(this.buildGradientShading((GradientPaint)paint, state));
                }
                if (paint instanceof TexturePaint) {
                    this.applyTexturePaint((TexturePaint)paint, state);
                } else {
                    System.err.println("Don't know paint " + paint.getClass().getName());
                }
            }
        }
        return null;
    }

    private void applyPatternPaint(Paint paint, PaintApplierState state) throws IOException {
        Rectangle2D anchorRect = (Rectangle2D)this.getPropertyValue(paint, "getPatternRect");
        AffineTransform paintPatternTransform = (AffineTransform)this.getPropertyValue(paint, "getPatternTransform");
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        pattern.setBBox(new PDRectangle((float)anchorRect.getX(), (float)anchorRect.getY(), (float)anchorRect.getWidth(), (float)anchorRect.getHeight()));
        pattern.setXStep((float)anchorRect.getWidth());
        pattern.setYStep((float)anchorRect.getHeight());
        AffineTransform patternTransform = new AffineTransform();
        if (paintPatternTransform != null) {
            paintPatternTransform = new AffineTransform(paintPatternTransform);
            paintPatternTransform.preConcatenate(state.tf);
            patternTransform.concatenate(paintPatternTransform);
        } else {
            patternTransform.concatenate(state.tf);
        }
        patternTransform.scale(1.0, -1.0);
        pattern.setMatrix(patternTransform);
        PDAppearanceStream appearance = new PDAppearanceStream(state.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        Object graphicsNode = this.getPropertyValue(paint, "getGraphicsNode");
        PdfBoxGraphics2D pdfBoxGraphics2D = new PdfBoxGraphics2D(state.document, pattern.getBBox(), state.env.getGraphics2D());
        try {
            Method paintMethod = graphicsNode.getClass().getMethod("paint", Graphics2D.class);
            paintMethod.invoke(graphicsNode, pdfBoxGraphics2D);
        }
        catch (Exception e) {
            System.err.println("PdfBoxGraphics2DPaintApplier error while drawing Batik PatternPaint");
            e.printStackTrace();
            return;
        }
        pdfBoxGraphics2D.dispose();
        PDFormXObject xFormObject = pdfBoxGraphics2D.getXFormObject();
        PDPageContentStream imageContentStream = new PDPageContentStream(state.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        imageContentStream.drawForm(xFormObject);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null);
        COSName tilingPatternName = state.resources.add((PDAbstractPattern)pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        state.contentStream.setNonStrokingColor(patternColor);
        state.contentStream.setStrokingColor(patternColor);
    }

    private void applyComposite(PaintApplierState state) {
        if (state.composite == null) {
            return;
        }
        float alpha = 1.0f;
        COSName blendMode = COSName.COMPATIBLE;
        int rule = 2;
        if (state.composite instanceof AlphaComposite) {
            AlphaComposite composite = (AlphaComposite)state.composite;
            alpha = composite.getAlpha();
            rule = composite.getRule();
        } else if (state.composite.getClass().getSimpleName().equals("SVGComposite")) {
            alpha = ((Float)this.getPropertyValue(state.composite, "alpha")).floatValue();
            rule = (Integer)this.getPropertyValue(state.composite, "rule");
        } else {
            System.err.println("Unknown composite " + state.composite.getClass().getSimpleName());
        }
        state.ensureExtendedState();
        if (alpha < 1.0f) {
            state.pdExtendedGraphicsState.setStrokingAlphaConstant(Float.valueOf(alpha));
            state.pdExtendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(alpha));
        }
        switch (rule) {
            case 1: {
                break;
            }
            case 2: {
                blendMode = COSName.NORMAL;
                break;
            }
            case 3: {
                blendMode = COSName.COMPATIBLE;
                break;
            }
            case 12: {
                blendMode = COSName.EXCLUSION;
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 10: {
                blendMode = COSName.COMPATIBLE;
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
        }
        state.dictExtendedState.setItem(COSName.BM, (COSBase)blendMode);
    }

    private PDShading buildLinearGradientShading(Paint paint, PaintApplierState state) throws IOException {
        Color[] colors = (Color[])this.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = (float[])this.getPropertyValue(paint, "getFractions");
        Point2D startPoint = (Point2D)this.getPropertyValue(paint, "getStartPoint");
        Point2D endPoint = (Point2D)this.getPropertyValue(paint, "getEndPoint");
        AffineTransform gradientTransform = (AffineTransform)this.getPropertyValue(paint, "getTransform");
        state.tf.concatenate(gradientTransform);
        state.tf.transform(startPoint, startPoint);
        state.tf.transform(endPoint, endPoint);
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)startPoint.getX()));
        coords.add((COSBase)new COSFloat((float)startPoint.getY()));
        coords.add((COSBase)new COSFloat((float)endPoint.getX()));
        coords.add((COSBase)new COSFloat((float)endPoint.getY()));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private PDShading buildRadialGradientShading(Paint paint, PaintApplierState state) throws IOException {
        Color[] colors = (Color[])this.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(3);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = (float[])this.getPropertyValue(paint, "getFractions");
        Point2D centerPoint = (Point2D)this.getPropertyValue(paint, "getCenterPoint");
        Point2D focusPoint = (Point2D)this.getPropertyValue(paint, "getFocusPoint");
        AffineTransform gradientTransform = (AffineTransform)this.getPropertyValue(paint, "getTransform");
        state.tf.concatenate(gradientTransform);
        state.tf.transform(centerPoint, centerPoint);
        state.tf.transform(focusPoint, focusPoint);
        float radius = ((Float)this.getPropertyValue(paint, "getRadius")).floatValue();
        radius = (float)Math.abs((double)radius * state.tf.getScaleX());
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)centerPoint.getX()));
        coords.add((COSBase)new COSFloat((float)centerPoint.getY()));
        coords.add((COSBase)new COSFloat(0.0f));
        coords.add((COSBase)new COSFloat((float)focusPoint.getX()));
        coords.add((COSBase)new COSFloat((float)focusPoint.getY()));
        coords.add((COSBase)new COSFloat(radius));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private PDShading buildGradientShading(GradientPaint gradientPaint, PaintApplierState state) throws IOException {
        Color[] colors = new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()};
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = new float[]{0.0f, 1.0f};
        Point2D startPoint = gradientPaint.getPoint1();
        Point2D endPoint = gradientPaint.getPoint2();
        state.tf.transform(startPoint, startPoint);
        state.tf.transform(endPoint, endPoint);
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)startPoint.getX()));
        coords.add((COSBase)new COSFloat((float)startPoint.getY()));
        coords.add((COSBase)new COSFloat((float)endPoint.getX()));
        coords.add((COSBase)new COSFloat((float)endPoint.getY()));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private void applyTexturePaint(TexturePaint texturePaint, PaintApplierState state) throws IOException {
        Rectangle2D anchorRect = texturePaint.getAnchorRect();
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        pattern.setBBox(new PDRectangle((float)anchorRect.getX(), (float)anchorRect.getY(), (float)anchorRect.getWidth(), (float)anchorRect.getHeight()));
        pattern.setXStep((float)anchorRect.getWidth());
        pattern.setYStep((float)anchorRect.getHeight());
        AffineTransform patternTransform = new AffineTransform();
        patternTransform.translate(0.0, anchorRect.getHeight());
        patternTransform.scale(1.0, -1.0);
        pattern.setMatrix(patternTransform);
        PDAppearanceStream appearance = new PDAppearanceStream(state.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        PDPageContentStream imageContentStream = new PDPageContentStream(state.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        BufferedImage texturePaintImage = texturePaint.getImage();
        PDImageXObject imageXObject = state.imageEncoder.encodeImage(state.document, imageContentStream, texturePaintImage);
        float ratioW = (float)(anchorRect.getWidth() / (double)texturePaintImage.getWidth());
        float ratioH = (float)(anchorRect.getHeight() / (double)texturePaintImage.getHeight());
        float paintHeight = (float)texturePaintImage.getHeight() * ratioH;
        imageContentStream.drawImage(imageXObject, (float)anchorRect.getX(), (float)((double)paintHeight + anchorRect.getY()), (float)texturePaintImage.getWidth() * ratioW, -paintHeight);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null, imageXObject.getColorSpace());
        COSName tilingPatternName = state.resources.add((PDAbstractPattern)pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        state.contentStream.setNonStrokingColor(patternColor);
        state.contentStream.setStrokingColor(patternColor);
    }

    protected PDFunctionType3 buildType3Function(Color[] colors, float[] fractions, PaintApplierState state) {
        COSDictionary function = new COSDictionary();
        function.setInt(COSName.FUNCTION_TYPE, 3);
        COSArray domain = new COSArray();
        domain.add((COSBase)new COSFloat(0.0f));
        domain.add((COSBase)new COSFloat(1.0f));
        COSArray encode = new COSArray();
        COSArray range = new COSArray();
        range.add((COSBase)new COSFloat(0.0f));
        range.add((COSBase)new COSFloat(1.0f));
        COSArray bounds = new COSArray();
        for (int i = 2; i < colors.length; ++i) {
            bounds.add((COSBase)new COSFloat(1.0f / (float)colors.length * (float)(i - 1)));
        }
        COSArray functions = this.buildType2Functions(colors, domain, encode, state);
        function.setItem(COSName.FUNCTIONS, (COSBase)functions);
        function.setItem(COSName.BOUNDS, (COSBase)bounds);
        function.setItem(COSName.ENCODE, (COSBase)encode);
        PDFunctionType3 type3 = new PDFunctionType3((COSBase)function);
        type3.setDomainValues(domain);
        return type3;
    }

    protected COSArray buildType2Functions(Color[] colors, COSArray domain, COSArray encode, PaintApplierState state) {
        Color prevColor = colors[0];
        COSArray functions = new COSArray();
        for (int i = 1; i < colors.length; ++i) {
            Color color = colors[i];
            PDColor prevPdColor = state.colorMapper.mapColor(state.contentStream, prevColor);
            PDColor pdColor = state.colorMapper.mapColor(state.contentStream, color);
            COSArray c0 = new COSArray();
            COSArray c1 = new COSArray();
            for (float component : prevPdColor.getComponents()) {
                c0.add((COSBase)new COSFloat(component));
            }
            for (float component : pdColor.getComponents()) {
                c1.add((COSBase)new COSFloat(component));
            }
            COSDictionary type2Function = new COSDictionary();
            type2Function.setInt(COSName.FUNCTION_TYPE, 2);
            type2Function.setItem(COSName.C0, (COSBase)c0);
            type2Function.setItem(COSName.C1, (COSBase)c1);
            type2Function.setInt(COSName.N, 1);
            type2Function.setItem(COSName.DOMAIN, (COSBase)domain);
            functions.add((COSBase)type2Function);
            encode.add((COSBase)new COSFloat(0.0f));
            encode.add((COSBase)new COSFloat(1.0f));
            prevColor = color;
        }
        return functions;
    }

    protected <T> T getPropertyValue(Object obj, String propertyGetter) {
        try {
            for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
                try {
                    Method m = c.getMethod(propertyGetter, null);
                    return (T)m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            throw new NullPointerException("Method " + propertyGetter + " not found!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class PDShadingCache
    extends COSResourceCacheBase<PDShading> {
        private PDShadingCache() {
        }

        @Override
        protected int getKey(PDShading obj) {
            return obj.getCOSObject().size();
        }
    }

    private static class ExtGStateCache
    extends COSResourceCacheBase<PDExtendedGraphicsState> {
        private ExtGStateCache() {
        }

        @Override
        protected int getKey(PDExtendedGraphicsState obj) {
            return obj.getCOSObject().size();
        }
    }

    private static abstract class COSResourceCacheBase<TObject extends COSObjectable> {
        private Map<Integer, List<TObject>> states = new HashMap<Integer, List<TObject>>();

        private COSResourceCacheBase() {
        }

        private static boolean equalsCOSDictionary(COSDictionary cosDictionary, COSDictionary cosDictionary1) {
            if (cosDictionary.size() != cosDictionary1.size()) {
                return false;
            }
            for (COSName name : cosDictionary.keySet()) {
                COSBase item2;
                COSBase item = cosDictionary.getItem(name);
                if (COSResourceCacheBase.equalsCOSBase(item, item2 = cosDictionary1.getItem(name))) continue;
                return false;
            }
            return true;
        }

        private static boolean equalsCOSBase(COSBase item, COSBase item2) {
            if (item == item2) {
                return true;
            }
            if (item == null) {
                return false;
            }
            if (item2 == null) {
                return false;
            }
            if (item.equals(item2)) {
                return true;
            }
            if (item instanceof COSDictionary && item2 instanceof COSDictionary) {
                return COSResourceCacheBase.equalsCOSDictionary((COSDictionary)item, (COSDictionary)item2);
            }
            if (item instanceof COSArray && item2 instanceof COSArray) {
                return COSResourceCacheBase.equalsCOSArray((COSArray)item, (COSArray)item2);
            }
            return false;
        }

        private static boolean equalsCOSArray(COSArray item, COSArray item2) {
            if (item.size() != item2.size()) {
                return false;
            }
            for (int i = 0; i < item.size(); ++i) {
                COSBase i2;
                COSBase i1 = item.getObject(i);
                if (COSResourceCacheBase.equalsCOSBase(i1, i2 = item2.getObject(i))) continue;
                return false;
            }
            return true;
        }

        protected abstract int getKey(TObject var1);

        TObject makeUnqiue(TObject state) {
            int key = this.getKey(state);
            List<TObject> pdExtendedGraphicsStates = this.states.get(key);
            if (pdExtendedGraphicsStates == null) {
                pdExtendedGraphicsStates = new ArrayList<TObject>();
                this.states.put(key, pdExtendedGraphicsStates);
            }
            for (COSObjectable s : pdExtendedGraphicsStates) {
                if (!this.stateEquals(s, state)) continue;
                return (TObject)s;
            }
            pdExtendedGraphicsStates.add(state);
            return state;
        }

        private boolean stateEquals(TObject s, TObject state) {
            COSBase base1 = s.getCOSObject();
            COSBase base2 = state.getCOSObject();
            return COSResourceCacheBase.equalsCOSBase(base1, base2);
        }
    }

    protected class PaintApplierState {
        protected PDDocument document;
        protected PDPageContentStream contentStream;
        protected IPdfBoxGraphics2DColorMapper colorMapper;
        protected IPdfBoxGraphics2DImageEncoder imageEncoder;
        protected PDResources resources;
        protected PDExtendedGraphicsState pdExtendedGraphicsState;
        protected Composite composite;
        private COSDictionary dictExtendedState;
        private IPdfBoxGraphics2DPaintApplier.IPaintEnv env;
        public AffineTransform tf;

        protected PaintApplierState() {
        }

        private void ensureExtendedState() {
            if (this.pdExtendedGraphicsState == null) {
                this.dictExtendedState = new COSDictionary();
                this.dictExtendedState.setItem(COSName.TYPE, (COSBase)COSName.EXT_G_STATE);
                this.pdExtendedGraphicsState = new PDExtendedGraphicsState(this.dictExtendedState);
            }
        }
    }
}

