/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BannedImportGroup {
    private final List<PackagePattern> basePackages;
    private final List<PackagePattern> bannedImports;
    private final List<PackagePattern> allowedImports;
    private final List<PackagePattern> excludedClasses;
    private final String reason;

    private BannedImportGroup(List<PackagePattern> basePackages, List<PackagePattern> bannedImports, List<PackagePattern> allowedImports, List<PackagePattern> excludedClasses, String reason) {
        this.basePackages = basePackages;
        this.bannedImports = bannedImports;
        this.allowedImports = allowedImports;
        this.excludedClasses = excludedClasses;
        this.reason = reason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<PackagePattern> getBasePackages() {
        return this.basePackages;
    }

    public boolean basePackageMatches(String fqcn) {
        return this.matchesAnyPattern(fqcn, this.basePackages);
    }

    public List<PackagePattern> getBannedImports() {
        return this.bannedImports;
    }

    public Optional<PackagePattern> ifImportIsBanned(String importName) {
        return this.bannedImports.stream().filter(bannedImport -> bannedImport.matches(importName)).filter(result -> !this.allowedImportMatches(importName)).findFirst();
    }

    public List<PackagePattern> getAllowedImports() {
        return this.allowedImports;
    }

    public boolean allowedImportMatches(String importName) {
        return this.matchesAnyPattern(importName, this.allowedImports);
    }

    public List<PackagePattern> getExcludedClasses() {
        return this.excludedClasses;
    }

    public boolean exclusionMatches(String fqcn) {
        return this.matchesAnyPattern(fqcn, this.excludedClasses);
    }

    private boolean matchesAnyPattern(String packageName, Collection<PackagePattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matches(packageName));
    }

    public String getReason() {
        return this.reason;
    }

    public int hashCode() {
        return Objects.hash(this.basePackages, this.bannedImports, this.allowedImports, this.excludedClasses, this.reason);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BannedImportGroup && Objects.equals(this.basePackages, ((BannedImportGroup)obj).basePackages) && Objects.equals(this.bannedImports, ((BannedImportGroup)obj).bannedImports) && Objects.equals(this.allowedImports, ((BannedImportGroup)obj).allowedImports) && Objects.equals(this.excludedClasses, ((BannedImportGroup)obj).excludedClasses) && Objects.equals(this.reason, ((BannedImportGroup)obj).reason);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("basePackages", this.basePackages).add("bannedImports", this.bannedImports).add("allowedImports", this.allowedImports).add("excludedClasses", this.excludedClasses).add("reason", (Object)this.reason).toString();
    }

    public static class Builder {
        private List<PackagePattern> basePackages = ImmutableList.of();
        private List<PackagePattern> bannedImports = ImmutableList.of();
        private List<PackagePattern> allowedImports = ImmutableList.of();
        private List<PackagePattern> excludedClasses = ImmutableList.of();
        private String reason;

        private Builder() {
        }

        public Builder withBasePackages(List<PackagePattern> basePackages) {
            this.basePackages = basePackages;
            return this;
        }

        public Builder withBasePackages(String ... basePackages) {
            return this.withBasePackages(PackagePattern.parseAll(Arrays.asList(basePackages)));
        }

        public Builder withBannedImports(List<PackagePattern> bannedImports) {
            this.bannedImports = bannedImports;
            return this;
        }

        public Builder withBannedImports(String ... bannedImports) {
            return this.withBannedImports(PackagePattern.parseAll(Arrays.asList(bannedImports)));
        }

        public Builder withAllowedImports(List<PackagePattern> allowedImports) {
            this.allowedImports = allowedImports;
            return this;
        }

        public Builder withAllowedImports(String ... allowedImports) {
            return this.withAllowedImports(PackagePattern.parseAll(Arrays.asList(allowedImports)));
        }

        public Builder withExcludedClasses(List<PackagePattern> excludedClasses) {
            this.excludedClasses = excludedClasses;
            return this;
        }

        public Builder withExcludedClasses(String ... excludedClasses) {
            return this.withExcludedClasses(PackagePattern.parseAll(Arrays.asList(excludedClasses)));
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public BannedImportGroup build() {
            BannedImportGroup group = new BannedImportGroup(this.basePackages, this.bannedImports, this.allowedImports, this.excludedClasses, this.reason);
            this.checkGroupConsistency(group);
            return group;
        }

        private void checkGroupConsistency(BannedImportGroup group) {
            this.checkBannedImportsPresent(group);
            this.allowedImportMustMatchBannedPattern(group);
            this.checkBasePackageNotStatic(group);
            this.checkExclusionNotStatic(group);
            this.exclusionsMustMatchBasePattern(group);
        }

        private void checkBasePackageNotStatic(BannedImportGroup group) {
            if (group.getBasePackages().stream().anyMatch(PackagePattern::isStatic)) {
                throw new BannedImportDefinitionException("Base packages must not be static");
            }
        }

        private void checkExclusionNotStatic(BannedImportGroup group) {
            if (group.getExcludedClasses().stream().anyMatch(PackagePattern::isStatic)) {
                throw new BannedImportDefinitionException("Exclusions must not be static");
            }
        }

        private void checkBannedImportsPresent(BannedImportGroup group) {
            if (group.getBannedImports().isEmpty()) {
                throw new BannedImportDefinitionException("There are no banned imports specified");
            }
        }

        private void allowedImportMustMatchBannedPattern(BannedImportGroup group) {
            for (PackagePattern allowedImport : group.getAllowedImports()) {
                boolean matches = group.getBannedImports().stream().anyMatch(bannedPackage -> bannedPackage.matches(allowedImport));
                if (matches) continue;
                throw new BannedImportDefinitionException(String.format("The allowed import pattern '%s' does not match any banned package.", allowedImport));
            }
        }

        private void exclusionsMustMatchBasePattern(BannedImportGroup group) {
            for (PackagePattern excludedClass : group.getExcludedClasses()) {
                boolean matches = group.getBasePackages().stream().anyMatch(basePackage -> basePackage.matches(excludedClass));
                if (matches) continue;
                throw new BannedImportDefinitionException(String.format("The exclusion pattern '%s' does not match any base package.", excludedClass));
            }
        }
    }
}

