/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.LineSupplier;
import de.skuzzle.enforcer.restrictimports.analyze.RuntimeIOException;
import de.skuzzle.enforcer.restrictimports.analyze.TransientCommentReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

class SkipCommentsLineSupplier
implements LineSupplier {
    private final Charset charset;
    private final int commentLineBufferSize;

    public SkipCommentsLineSupplier(Charset charset, int commentLineBufferSize) {
        this.charset = charset;
        this.commentLineBufferSize = commentLineBufferSize;
    }

    @Override
    public Stream<String> lines(Path path) throws IOException {
        BufferedReader fromFile = Files.newBufferedReader(path, this.charset);
        TransientCommentReader skipComments = new TransientCommentReader(fromFile, true, this.commentLineBufferSize);
        BufferedReader lineReader = new BufferedReader(skipComments);
        return (Stream)lineReader.lines().onClose(() -> this.close(lineReader));
    }

    private void close(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error while closing reader", e);
        }
    }
}

