/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import com.diffplug.common.swt.os.SwtPlatform;
import dev.equo.solstice.p2.P2Session;
import dev.equo.solstice.p2.P2Unit;
import dev.equo.solstice.p2.RepoStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class P2Query {
    private final P2Session session;
    private final TreeSet<String> exclude = new TreeSet();
    private final TreeSet<String> excludePrefix = new TreeSet();
    private final TreeSet<String> excludeSuffix = new TreeSet();
    private final TreeMap<String, String> filterProps = new TreeMap();
    private final TreeMap<String, P2Unit> installed = new TreeMap();
    private final TreeMap<P2Session.Requirement, Set<P2Unit>> optionalSoMaybeNotInstalled = new TreeMap();
    private final TreeMap<P2Session.Requirement, Set<P2Unit>> unmetRequirements = new TreeMap();
    private final TreeSet<P2Session.Requirement> ambiguousRequirements = new TreeSet();

    P2Query(P2Session session) {
        this.session = session;
    }

    private void assertNotUsed() {
        if (!this.installed.isEmpty()) {
            throw new IllegalStateException("You must not change any filter properties after you have already called `install` or `addAllUnits`.");
        }
    }

    public void exclude(String toExclude) {
        this.assertNotUsed();
        this.exclude.add(toExclude);
    }

    public void excludePrefix(String prefix) {
        this.assertNotUsed();
        this.excludePrefix.add(prefix);
    }

    public void excludeSuffix(String prefix) {
        this.assertNotUsed();
        this.excludeSuffix.add(prefix);
    }

    public void platform(SwtPlatform platform) {
        this.assertNotUsed();
        if (platform == null) {
            throw new IllegalArgumentException("Use `platformAll()` or `platformNone()`");
        }
        this.filterProps.put("osgi.os", platform.getOs());
        this.filterProps.put("osgi.ws", platform.getWs());
        this.filterProps.put("osgi.arch", platform.getArch());
    }

    public void platformAll() {
        this.assertNotUsed();
        this.filterProps.remove("osgi.os");
        this.filterProps.remove("osgi.ws");
        this.filterProps.remove("osgi.arch");
    }

    public void platformNone() {
        this.assertNotUsed();
        this.filterProps.put("osgi.os", "zzz");
        this.filterProps.put("osgi.ws", "zzz");
        this.filterProps.put("osgi.arch", "zzz");
    }

    public void filterProp(String key, String value) {
        this.assertNotUsed();
        this.filterProps.put(key, value);
    }

    public void install(String idToResolve) {
        this.install(this.session.getUnitById(idToResolve));
    }

    public P2Unit getInstalledUnitById(String id) {
        return this.installed.get(id);
    }

    public List<P2Unit> getAllAvailableUnitsById(String id) {
        return this.session.units.stream().filter(u -> u.id.equals(id)).collect(Collectors.toList());
    }

    private boolean addUnlessExcludedOrAlreadyPresent(P2Unit unit) {
        for (String prefix : this.excludePrefix) {
            if (!unit.id.startsWith(prefix)) continue;
            return false;
        }
        for (String suffix : this.excludeSuffix) {
            if (!unit.id.endsWith(suffix)) continue;
            return false;
        }
        if (this.exclude.contains(unit.id)) {
            return false;
        }
        if (!this.filterProps.isEmpty() && unit.filter != null && !unit.filter.matches(this.filterProps)) {
            return false;
        }
        return this.installed.putIfAbsent(unit.id, unit) == null;
    }

    private boolean reqMatchesFilter(P2Session.Requirement req) {
        return this.filterProps.isEmpty() || req.getFilter() == null || req.getFilter().matches(this.filterProps);
    }

    private void install(P2Unit toResolve) {
        if (!this.addUnlessExcludedOrAlreadyPresent(toResolve)) {
            return;
        }
        for (P2Session.Requirement requirement : toResolve.requires) {
            if (!this.reqMatchesFilter(requirement)) continue;
            if (requirement.isOptional()) {
                this.optionalSoMaybeNotInstalled.computeIfAbsent(requirement.getRoot(), unused -> new TreeSet()).add(toResolve);
                continue;
            }
            if (requirement.hasOnlyOneProvider()) {
                this.install(requirement.getOnlyProvider());
                continue;
            }
            List<P2Unit> units = requirement.getProviders();
            if (units.isEmpty()) {
                this.addUnmetRequirement(requirement, toResolve);
                continue;
            }
            if (units.stream().anyMatch(u -> u.id.equals("a.jre.javase"))) continue;
            this.install(units.get(0));
            this.ambiguousRequirements.add(requirement);
        }
    }

    private void addUnmetRequirement(P2Session.Requirement providers, P2Unit needsIt) {
        Set whoNeedsIt = this.unmetRequirements.computeIfAbsent(providers, unused -> new TreeSet());
        whoNeedsIt.add(needsIt);
    }

    public List<P2Unit> getJars() {
        return this.getUnitsWithProperty("artifact-classifier", "osgi.bundle");
    }

    public List<P2Unit> getFeatures() {
        return this.getUnitsWithProperty1or2("org.eclipse.equinox.p2.type.group", "true", "artifact-classifier", "org.eclipse.update.feature");
    }

    public List<P2Unit> getCategories() {
        return this.getUnitsWithProperty("org.eclipse.equinox.p2.type.category", "true");
    }

    public List<P2Unit> getUnitsWithProperty(String key, String value) {
        ArrayList<P2Unit> matches = new ArrayList<P2Unit>();
        for (P2Unit unit : this.installed.values()) {
            if (!Objects.equals(value, unit.properties.get(key))) continue;
            matches.add(unit);
        }
        return matches;
    }

    public List<P2Unit> getUnitsWithProperty1or2(String key1, String value1, String key2, String value2) {
        ArrayList<P2Unit> matches = new ArrayList<P2Unit>();
        for (P2Unit unit : this.installed.values()) {
            if (!Objects.equals(unit.properties.get(key1), value1) && !Objects.equals(unit.properties.get(key2), value2)) continue;
            matches.add(unit);
        }
        return matches;
    }

    public List<String> getJarsOnMavenCentral(boolean useMavenCentral) {
        ArrayList<String> mavenCoords = new ArrayList<String>();
        if (useMavenCentral) {
            for (P2Unit unit : this.getJars()) {
                RepoStatus repoStatus = RepoStatus.forUnit(unit);
                if (!repoStatus.isOnMavenCentral()) continue;
                mavenCoords.add(repoStatus.coordinate());
            }
        }
        return mavenCoords;
    }

    public List<P2Unit> getJarsNotOnMavenCentral(boolean useMavenCentral) {
        ArrayList<P2Unit> notOnMaven = new ArrayList<P2Unit>();
        for (P2Unit unit : this.getJars()) {
            RepoStatus repoStatus = RepoStatus.forUnit(unit);
            if (repoStatus.isOnMavenCentral() && useMavenCentral) continue;
            notOnMaven.add(unit);
        }
        return notOnMaven;
    }

    public void addAllUnits() {
        this.session.units.forEach(this::addUnlessExcludedOrAlreadyPresent);
    }

    public Set<P2Session.Requirement> getAmbiguousRequirements() {
        Iterator<P2Session.Requirement> iter = this.ambiguousRequirements.iterator();
        while (iter.hasNext()) {
            P2Session.Requirement req = iter.next();
            if (!req.getProviders().stream().allMatch(this::isInstalled)) continue;
            iter.remove();
        }
        return this.ambiguousRequirements;
    }

    public Map<P2Session.Requirement, Set<P2Unit>> getUnmetRequirements() {
        return this.unmetRequirements;
    }

    public boolean isInstalled(P2Unit unit) {
        return this.installed.get(unit.getId()) == unit;
    }

    public Map<P2Session.Requirement, Set<P2Unit>> getOptionalRequirementsNotInstalled() {
        Iterator<Map.Entry<P2Session.Requirement, Set<P2Unit>>> iter = this.optionalSoMaybeNotInstalled.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<P2Session.Requirement, Set<P2Unit>> entry = iter.next();
            P2Session.Requirement req = entry.getKey();
            if (req.getProviders().stream().anyMatch(this::isInstalled)) {
                iter.remove();
                continue;
            }
            if (!req.getProviders().stream().anyMatch(u -> u.id.equals("a.jre.javase"))) continue;
            iter.remove();
        }
        return this.optionalSoMaybeNotInstalled;
    }
}

