/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.hilla.engine.EngineConfiguration;
import dev.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OpenAPIUtil {
    public static String getCurrentOpenAPI(Path buildDirectory) throws IOException {
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)buildDirectory);
        return Files.readString(engineConfiguration.getOpenAPIFile());
    }

    public static String generateOpenAPI(Path buildDirectory) throws IOException {
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)buildDirectory);
        ParserProcessor parserProcessor = new ParserProcessor(engineConfiguration, OpenAPIUtil.class.getClassLoader());
        return parserProcessor.createOpenAPI();
    }

    public static Set<String> findOpenApiClasses(String openApiAsText) throws IOException {
        ObjectNode schemas;
        JsonNode openApi = new ObjectMapper().readTree(openApiAsText);
        if (!openApi.has("components")) {
            return Collections.emptySet();
        }
        HashSet<String> types = new HashSet<String>();
        ArrayNode tags = (ArrayNode)openApi.get("tags");
        if (tags != null) {
            tags.forEach(nameAndClass -> types.add(nameAndClass.get("x-class-name").asText()));
        }
        if ((schemas = (ObjectNode)openApi.get("components").get("schemas")) != null) {
            schemas.fieldNames().forEachRemaining(type -> types.add((String)type));
        }
        return types;
    }
}

