/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import com.tschuchort.compiletesting.DiagnosticMessage;
import com.tschuchort.compiletesting.DiagnosticMessageKt;
import com.tschuchort.compiletesting.DiagnosticSeverity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u0005J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\"\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0018\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0019\u001a\u00020\u0003*\u00020\u0003H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/tschuchort/compiletesting/DiagnosticsMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "stepName", "", "verbose", "", "diagnostics", "", "Lcom/tschuchort/compiletesting/DiagnosticMessage;", "<init>", "(Ljava/lang/String;ZLjava/util/List;)V", "clear", "", "hasWarnings", "hasErrors", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "doReport", "Lcom/tschuchort/compiletesting/DiagnosticSeverity;", "stripPrefixes", "stripKind", "stripKspPrefix", "getSeverityFromPrefix", "getJavaVersion", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsMessageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsMessageCollector.kt\ncom/tschuchort/compiletesting/DiagnosticsMessageCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1807#2,3:145\n1807#2,3:148\n*S KotlinDebug\n*F\n+ 1 DiagnosticsMessageCollector.kt\ncom/tschuchort/compiletesting/DiagnosticsMessageCollector\n*L\n39#1:145,3\n44#1:148,3\n*E\n"})
public final class DiagnosticsMessageCollector
implements MessageCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String stepName;
    private final boolean verbose;
    @NotNull
    private final List<DiagnosticMessage> diagnostics;
    @NotNull
    private static final Regex KAPT_LOCATION_AND_KIND_REGEX = new Regex("^(.*\\.(kt|java)):(\\d+): (\\w+): ");
    @NotNull
    private static final Regex KIND_REGEX = new Regex("^(\\w+): ");
    @NotNull
    private static final Regex KSP_PREFIX_REGEX = new Regex("^\\[ksp] ");
    @NotNull
    private static final String KSP_ADDITIONAL_ERROR_MESSAGE = "Error occurred in KSP, check log for detail";

    public DiagnosticsMessageCollector(@NotNull String stepName, boolean verbose, @NotNull List<DiagnosticMessage> diagnostics) {
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        this.stepName = stepName;
        this.verbose = verbose;
        this.diagnostics = diagnostics;
    }

    public void clear() {
        this.diagnostics.clear();
    }

    public final boolean hasWarnings() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DiagnosticMessage it = (DiagnosticMessage)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == DiagnosticSeverity.WARNING)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DiagnosticMessage it = (DiagnosticMessage)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == DiagnosticSeverity.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        DiagnosticSeverity diagnosticSeverity;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.verbose && CompilerMessageSeverity.VERBOSE.contains(severity)) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.stepName, (Object)"kapt") && this.getJavaVersion() >= 17) {
            diagnosticSeverity = this.getSeverityFromPrefix(message);
            if (diagnosticSeverity == null) {
                diagnosticSeverity = DiagnosticMessageKt.toSeverity(severity);
            }
        } else {
            diagnosticSeverity = DiagnosticMessageKt.toSeverity(severity);
        }
        DiagnosticSeverity severity2 = diagnosticSeverity;
        this.doReport(severity2, message);
    }

    private final void doReport(DiagnosticSeverity severity, String message) {
        if (Intrinsics.areEqual((Object)message, (Object)KSP_ADDITIONAL_ERROR_MESSAGE)) {
            return;
        }
        String strippedMessage = this.stripPrefixes(message);
        this.diagnostics.add(new DiagnosticMessage(severity, strippedMessage));
    }

    private final String stripPrefixes(String $this$stripPrefixes) {
        return this.stripKspPrefix(this.stripKind($this$stripPrefixes));
    }

    private final String stripKind(String $this$stripKind) {
        String string = (String)SequencesKt.firstOrNull((Sequence)StringsKt.lineSequence((CharSequence)$this$stripKind));
        if (string == null) {
            return $this$stripKind;
        }
        String firstLine = string;
        MatchResult matchResult = Regex.find$default((Regex)KIND_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
        if (matchResult == null) {
            return $this$stripKind;
        }
        MatchResult match = matchResult;
        String string2 = $this$stripKind.substring(match.getRange().getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private final String stripKspPrefix(String $this$stripKspPrefix) {
        String string = (String)SequencesKt.firstOrNull((Sequence)StringsKt.lineSequence((CharSequence)$this$stripKspPrefix));
        if (string == null) {
            return $this$stripKspPrefix;
        }
        String firstLine = string;
        MatchResult matchResult = Regex.find$default((Regex)KSP_PREFIX_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
        if (matchResult == null) {
            return $this$stripKspPrefix;
        }
        MatchResult match = matchResult;
        String string2 = $this$stripKspPrefix.substring(match.getRange().getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private final DiagnosticSeverity getSeverityFromPrefix(String $this$getSeverityFromPrefix) {
        Object object;
        Object object2 = Regex.find$default((Regex)KAPT_LOCATION_AND_KIND_REGEX, (CharSequence)$this$getSeverityFromPrefix, (int)0, (int)2, null);
        if ((object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)CollectionsKt.getOrNull((List)object2, (int)4)) == null) && ((object = Regex.find$default((Regex)KIND_REGEX, (CharSequence)$this$getSeverityFromPrefix, (int)0, (int)2, null)) != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : (object2 = null)) == null) {
            return null;
        }
        Object kindMatch = object2;
        return StringsKt.equals((String)kindMatch, (String)"error", (boolean)true) ? DiagnosticSeverity.ERROR : (StringsKt.equals((String)kindMatch, (String)"warning", (boolean)true) ? DiagnosticSeverity.WARNING : (StringsKt.equals((String)kindMatch, (String)"note", (boolean)true) ? DiagnosticSeverity.INFO : null));
    }

    private final int getJavaVersion() {
        Object object = System.getProperty("java.specification.version");
        return object != null && (object = StringsKt.substringAfter$default((String)object, (char)'.', null, (int)2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 6;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/tschuchort/compiletesting/DiagnosticsMessageCollector$Companion;", "", "<init>", "()V", "KAPT_LOCATION_AND_KIND_REGEX", "Lkotlin/text/Regex;", "KIND_REGEX", "KSP_PREFIX_REGEX", "KSP_ADDITIONAL_ERROR_MESSAGE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

