/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import com.tschuchort.compiletesting.UtilsKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a8\u0006\u000b"}, d2={"getJavacVersionString", "", "javacCommand", "parseVersionString", "output", "isJavac9OrLater", "", "javacVersionString", "findToolsJarFromJdk", "Ljava/io/File;", "jdkHome", "core"})
@SourceDebugExtension(value={"SMAP\nJavacUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavacUtils.kt\ncom/tschuchort/compiletesting/JavacUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class JavacUtilsKt {
    @NotNull
    public static final String getJavacVersionString(@NotNull String javacCommand) {
        Intrinsics.checkNotNullParameter((Object)javacCommand, (String)"javacCommand");
        Object[] objectArray = new String[]{javacCommand, "-version"};
        Process javacProc = new ProcessBuilder(CollectionsKt.listOf((Object[])objectArray)).redirectErrorStream(true).start();
        Buffer buffer = new Buffer();
        InputStream inputStream = javacProc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)buffer.outputStream(), (int)0, (int)2, null);
        javacProc.waitFor();
        String output = buffer.readUtf8();
        String string = JavacUtilsKt.parseVersionString(output);
        if (string == null) {
            throw new IllegalStateException("Command '" + javacCommand + " -version' did not print expected output. Output was: '" + output + '\'');
        }
        return string;
    }

    @Nullable
    public static final String parseVersionString(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("javac (.*)?[\\s\\S]*"), (CharSequence)output, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getDestructured()) != null ? (String)matchResult.getMatch().getGroupValues().get(1) : null;
    }

    public static final boolean isJavac9OrLater(@NotNull String javacVersionString) {
        Intrinsics.checkNotNullParameter((Object)javacVersionString, (String)"javacVersionString");
        try {
            MatchResult.Destructured destructured;
            MatchResult matchResult = new Regex("([0-9]*)(?:\\.([0-9]*))?(?:\\.([0-9]*))?(.*)").matchEntire((CharSequence)javacVersionString);
            if (matchResult == null || (destructured = matchResult.getDestructured()) == null) {
                throw new IllegalArgumentException("Could not match version regex");
            }
            MatchResult.Destructured destructured2 = destructured;
            String majorv = (String)destructured2.getMatch().getGroupValues().get(1);
            String minorv = (String)destructured2.getMatch().getGroupValues().get(2);
            String patchv = (String)destructured2.getMatch().getGroupValues().get(3);
            String otherv = (String)destructured2.getMatch().getGroupValues().get(4);
            if (!(!StringsKt.isBlank((CharSequence)majorv))) {
                boolean $i$a$-check-JavacUtilsKt$isJavac9OrLater$32 = false;
                String $i$a$-check-JavacUtilsKt$isJavac9OrLater$32 = "Major version can not be blank";
                throw new IllegalStateException($i$a$-check-JavacUtilsKt$isJavac9OrLater$32.toString());
            }
            if (Integer.parseInt(majorv) == 1 && !(!StringsKt.isBlank((CharSequence)minorv))) {
                boolean bl = false;
                String string = "Minor version can not be blank if major version is 1";
                throw new IllegalStateException(string.toString());
            }
            return Integer.parseInt(majorv) == 1 && Integer.parseInt(minorv) >= 9 || Integer.parseInt(majorv) >= 9;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not parse javac version string: '" + javacVersionString + '\'', t);
        }
    }

    @NotNull
    public static final File findToolsJarFromJdk(@NotNull File jdkHome) {
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        File file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome, (String)"../lib/tools.jar"));
        if (file == null && (file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome, (String)"lib/tools.jar"))) == null && (file = UtilsKt.existsOrNull(FilesKt.resolve((File)jdkHome, (String)"tools.jar"))) == null) {
            throw new IllegalStateException("Can not find tools.jar from JDK with path " + jdkHome.getAbsolutePath());
        }
        return file;
    }
}

