/*
 * Decompiled with CFR 0.152.
 */
package com.tschuchort.compiletesting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/tschuchort/compiletesting/TeeOutputStream;", "Ljava/io/OutputStream;", "streams", "", "<init>", "(Ljava/util/Collection;)V", "", "([Ljava/io/OutputStream;)V", "getStreams", "()Ljava/util/Collection;", "write", "", "b", "", "", "off", "len", "flush", "close", "closeImpl", "streamsToClose", "core"})
public final class TeeOutputStream
extends OutputStream {
    @NotNull
    private final Collection<OutputStream> streams;

    public TeeOutputStream(@NotNull Collection<? extends OutputStream> streams) {
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        this.streams = streams;
    }

    @NotNull
    public final Collection<OutputStream> getStreams() {
        return this.streams;
    }

    public TeeOutputStream(OutputStream ... streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        this(ArraysKt.toList((Object[])streams));
    }

    @Override
    public synchronized void write(int b) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (OutputStream stream : this.streams) {
            stream.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeImpl(this.streams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeImpl(Collection<? extends OutputStream> streamsToClose) throws IOException {
        try {
            OutputStream outputStream = (OutputStream)CollectionsKt.firstOrNull((Iterable)streamsToClose);
            if (outputStream != null) {
                outputStream.close();
            }
        }
        finally {
            if (streamsToClose.size() > 1) {
                this.closeImpl(CollectionsKt.drop((Iterable)streamsToClose, (int)1));
            }
        }
    }
}

