/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;

public abstract class BaseSessionConfig
implements SessionConfig {
    private int idleTimeForRead;
    private int idleTimeForWrite;
    private int idleTimeForBoth;
    private int writeTimeout;

    protected BaseSessionConfig() {
    }

    public int getIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public long getIdleTimeInMillis(IdleStatus status) {
        return (long)this.getIdleTime(status) * 1000L;
    }

    public void setIdleTime(IdleStatus status, int idleTime) {
        if (idleTime < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + idleTime);
        }
        if (status == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = idleTime;
        } else if (status == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = idleTime;
        } else if (status == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = idleTime;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getWriteTimeoutInMillis() {
        return (long)this.writeTimeout * 1000L;
    }

    public void setWriteTimeout(int writeTimeout) {
        if (writeTimeout < 0) {
            throw new IllegalArgumentException("Illegal write timeout: " + writeTimeout);
        }
        this.writeTimeout = writeTimeout;
    }
}

