/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.mina.examples.echoserver.ssl.BogusTrustManagerFactory;

public class BogusSSLContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final String BOGUS_KEYSTORE = "bogus.cert";
    private static final char[] BOGUS_PW = new char[]{'b', 'o', 'g', 'u', 's', 'p', 'w'};
    private static SSLContext serverInstance = null;
    private static SSLContext clientInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext getInstance(boolean server) throws GeneralSecurityException {
        SSLContext retInstance = null;
        if (server) {
            if (serverInstance == null) {
                Class clazz = BogusSSLContextFactory.class;
                synchronized (clazz) {
                    if (serverInstance == null) {
                        try {
                            serverInstance = BogusSSLContextFactory.createBougusServerSSLContext();
                        }
                        catch (Exception ioe) {
                            throw new GeneralSecurityException("Can't create Server SSLContext:" + ioe);
                        }
                    }
                }
            }
            retInstance = serverInstance;
        } else {
            if (clientInstance == null) {
                Class clazz = BogusSSLContextFactory.class;
                synchronized (clazz) {
                    if (clientInstance == null) {
                        clientInstance = BogusSSLContextFactory.createBougusClientSSLContext();
                    }
                }
            }
            retInstance = clientInstance;
        }
        return retInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext createBougusServerSSLContext() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = BogusSSLContextFactory.class.getResourceAsStream(BOGUS_KEYSTORE);
            ks.load(in, BOGUS_PW);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, BOGUS_PW);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(kmf.getKeyManagers(), BogusTrustManagerFactory.X509_MANAGERS, null);
        return sslContext;
    }

    private static SSLContext createBougusClientSSLContext() throws GeneralSecurityException {
        SSLContext context = SSLContext.getInstance(PROTOCOL);
        context.init(null, BogusTrustManagerFactory.X509_MANAGERS, null);
        return context;
    }
}

