/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.examples.sumup.AddMessage;
import org.apache.mina.examples.sumup.ResultMessage;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;

public class ClientSessionHandler
implements ProtocolHandler {
    private final int[] values;
    private boolean finished;

    public ClientSessionHandler(int[] values) {
        this.values = values;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sessionOpened(ProtocolSession session) {
        System.out.println("OPENED");
        for (int i = 0; i < this.values.length; ++i) {
            AddMessage m = new AddMessage();
            m.setSequence(i);
            m.setValue(this.values[i]);
            session.write(m);
        }
    }

    public void sessionClosed(ProtocolSession session) {
        System.out.println("CLOSED");
    }

    public void messageReceived(ProtocolSession session, Object message) {
        System.out.println("RCVD: " + message);
        ResultMessage rm = (ResultMessage)message;
        if (rm.isOk()) {
            if (rm.getSequence() == this.values.length - 1) {
                System.out.println("The sum: " + rm.getValue());
                session.close();
                this.finished = true;
            }
        } else {
            System.err.println("Server error, disconnecting...");
            session.close();
            this.finished = true;
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        System.out.println("SENT: " + message);
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        cause.printStackTrace();
        session.close();
    }
}

