/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import org.apache.mina.util.Stack;

class SSLByteBufferPool {
    private static final int PACKET_BUFFER_INDEX = 0;
    private static final int APPLICATION_BUFFER_INDEX = 1;
    private static boolean initiated = false;
    private static final String DIRECT_MEMORY_PROP = "mina.sslfilter.directbuffer";
    private static boolean useDirectAllocatedBuffers = true;
    private static int packetBufferSize;
    private static int appBufferSize;
    private static int[] bufferStackSizes;
    private static final Stack[] bufferStacks;

    SSLByteBufferPool() {
    }

    static synchronized void initiate(SSLEngine sslEngine) {
        if (!initiated) {
            String prop = System.getProperty(DIRECT_MEMORY_PROP);
            if (prop != null) {
                useDirectAllocatedBuffers = Boolean.getBoolean(DIRECT_MEMORY_PROP);
            }
            packetBufferSize = sslEngine.getSession().getPacketBufferSize();
            appBufferSize = packetBufferSize * 2;
            SSLByteBufferPool.initiateBufferStacks();
            initiated = true;
        }
    }

    static ByteBuffer getPacketBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferPool.allocate(0);
    }

    static ByteBuffer getApplicationBuffer() {
        if (!initiated) {
            throw new IllegalStateException("Not initialized");
        }
        return SSLByteBufferPool.allocate(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer allocate(int idx) {
        ByteBuffer buf;
        Stack stack;
        Stack stack2 = stack = bufferStacks[idx];
        synchronized (stack2) {
            buf = (ByteBuffer)stack.pop();
            if (buf == null) {
                buf = SSLByteBufferPool.createBuffer(bufferStackSizes[idx]);
            }
        }
        buf.clear();
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ByteBuffer buf) {
        int stackIndex = SSLByteBufferPool.getBufferStackIndex(buf.capacity());
        if (stackIndex >= 0) {
            Stack stack;
            Stack stack2 = stack = bufferStacks[SSLByteBufferPool.getBufferStackIndex(buf.capacity())];
            synchronized (stack2) {
                stack.push(buf);
            }
        }
    }

    public static ByteBuffer expandBuffer(ByteBuffer buf, int newCapacity) {
        ByteBuffer newBuf = SSLByteBufferPool.createBuffer(newCapacity);
        buf.flip();
        newBuf.put(buf);
        SSLByteBufferPool.release(buf);
        return newBuf;
    }

    private static void initiateBufferStacks() {
        bufferStackSizes = new int[2];
        SSLByteBufferPool.bufferStackSizes[0] = packetBufferSize;
        SSLByteBufferPool.bufferStackSizes[1] = appBufferSize;
    }

    private static int getBufferStackIndex(int size) {
        if (size == packetBufferSize) {
            return 0;
        }
        if (size == appBufferSize) {
            return 1;
        }
        return -1;
    }

    private static ByteBuffer createBuffer(int capacity) {
        if (useDirectAllocatedBuffers) {
            try {
                return ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError e) {
                useDirectAllocatedBuffers = false;
                System.err.println("OutOfMemoryError: No more direct buffers available; trying heap buffer instead");
            }
        }
        return ByteBuffer.allocate(capacity);
    }

    static {
        bufferStacks = new Stack[]{new Stack(), new Stack()};
    }
}

