/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.socket;

import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.mina.common.BaseSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionFilterChain;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.socket.SocketIoProcessor;
import org.apache.mina.io.socket.SocketSessionConfig;
import org.apache.mina.util.Queue;

class SocketSession
extends BaseSession
implements IoSession {
    private final IoSessionManagerFilterChain managerFilterChain;
    private final IoSessionFilterChain filterChain;
    private final SocketChannel ch;
    private final SocketSessionConfig config;
    private final Queue writeBufferQueue;
    private final Queue writeMarkerQueue;
    private final IoHandler handler;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private SelectionKey key;
    private boolean disposed;

    SocketSession(IoSessionManagerFilterChain managerFilterChain, SocketChannel ch, IoHandler defaultHandler) {
        this.managerFilterChain = managerFilterChain;
        this.filterChain = new IoSessionFilterChain(managerFilterChain);
        this.ch = ch;
        this.config = new SocketSessionConfig(this);
        this.writeBufferQueue = new Queue();
        this.writeMarkerQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
    }

    IoSessionManagerFilterChain getManagerFilterChain() {
        return this.managerFilterChain;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    SocketChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    synchronized void notifyClose() {
        if (!this.disposed) {
            this.disposed = true;
            this.notify();
        }
    }

    public synchronized void close(boolean wait) {
        if (this.disposed) {
            return;
        }
        SocketIoProcessor.getInstance().removeSession(this);
        if (wait) {
            while (this.disposed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    Queue getWriteBufferQueue() {
        return this.writeBufferQueue;
    }

    Queue getWriteMarkerQueue() {
        return this.writeMarkerQueue;
    }

    public void write(ByteBuffer buf, Object marker) {
        this.filterChain.filterWrite(this, buf, marker);
    }

    public TransportType getTransportType() {
        return TransportType.SOCKET;
    }

    public boolean isConnected() {
        return this.ch.isConnected();
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

