/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolHandlerFilter;
import org.apache.mina.protocol.ProtocolHandlerFilterChain;
import org.apache.mina.protocol.ProtocolSession;

public abstract class AbstractProtocolHandlerFilterChain
implements ProtocolHandlerFilterChain {
    private final Map name2entry = new HashMap();
    private final Map filter2entry = new IdentityHashMap();
    private final Entry head = new Entry(null, null, "head", this.createHeadFilter());
    private final Entry tail = new Entry(this.head, null, "tail", this.createTailFilter());

    protected AbstractProtocolHandlerFilterChain() {
        this.head.nextEntry = this.tail;
    }

    protected ProtocolHandlerFilter createHeadFilter() {
        return new ProtocolHandlerFilter(){

            public void sessionOpened(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session) {
                nextFilter.sessionOpened(session);
            }

            public void sessionClosed(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session) {
                nextFilter.sessionClosed(session);
            }

            public void sessionIdle(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) {
                nextFilter.sessionIdle(session, status);
            }

            public void exceptionCaught(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) {
                nextFilter.exceptionCaught(session, cause);
            }

            public void messageReceived(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                nextFilter.messageReceived(session, message);
            }

            public void messageSent(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                nextFilter.messageSent(session, message);
            }

            public void filterWrite(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                AbstractProtocolHandlerFilterChain.this.doWrite(session, message);
            }
        };
    }

    protected ProtocolHandlerFilter createTailFilter() {
        return new ProtocolHandlerFilter(){

            public void sessionOpened(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session) {
                session.getHandler().sessionOpened(session);
            }

            public void sessionClosed(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session) {
                session.getHandler().sessionClosed(session);
            }

            public void sessionIdle(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) {
                session.getHandler().sessionIdle(session, status);
            }

            public void exceptionCaught(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) {
                session.getHandler().exceptionCaught(session, cause);
            }

            public void messageReceived(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                ProtocolHandler handler = session.getHandler();
                handler.messageReceived(session, message);
            }

            public void messageSent(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                session.getHandler().messageSent(session, message);
            }

            public void filterWrite(ProtocolHandlerFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
                nextFilter.filterWrite(session, message);
            }
        };
    }

    public ProtocolHandlerFilter getChild(String name) {
        Entry e = (Entry)this.name2entry.get(name);
        if (e == null) {
            return null;
        }
        return e.filter;
    }

    public synchronized void addFirst(String name, ProtocolHandlerFilter filter) {
        this.checkAddable(name);
        this.register(this.head, name, filter);
    }

    public synchronized void addLast(String name, ProtocolHandlerFilter filter) {
        this.checkAddable(name);
        this.register(this.tail.prevEntry, name, filter);
    }

    public synchronized void addBefore(String baseName, String name, ProtocolHandlerFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry, name, filter);
    }

    public synchronized void addAfter(String baseName, String name, ProtocolHandlerFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry.prevEntry, name, filter);
    }

    public synchronized void remove(String name) {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        prevEntry.nextEntry = nextEntry;
        nextEntry.prevEntry = prevEntry;
        this.name2entry.remove(name);
        ProtocolHandlerFilter filter = entry.filter;
        this.filter2entry.remove(filter);
    }

    public synchronized void clear() {
        Iterator it = new ArrayList(this.name2entry.keySet()).iterator();
        while (it.hasNext()) {
            this.remove((String)it.next());
        }
    }

    private void register(Entry prevEntry, String name, ProtocolHandlerFilter filter) {
        Entry newEntry = new Entry(prevEntry, prevEntry.nextEntry, name, filter);
        prevEntry.nextEntry.prevEntry = newEntry;
        prevEntry.nextEntry = newEntry;
        this.name2entry.put(name, newEntry);
        this.filter2entry.put(filter, newEntry);
    }

    private Entry checkOldName(String baseName) {
        Entry e = (Entry)this.name2entry.get(baseName);
        if (e == null) {
            throw new IllegalArgumentException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(String name) {
        if (this.name2entry.containsKey(name)) {
            throw new IllegalArgumentException("Other interceptor is using name '" + name + "'");
        }
    }

    public void sessionOpened(ProtocolSession session) {
        Entry head = this.head;
        this.callNextSessionOpened(head, session);
    }

    private void callNextSessionOpened(Entry entry, ProtocolSession session) {
        try {
            entry.filter.sessionOpened(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionClosed(ProtocolSession session) {
        Entry head = this.head;
        this.callNextSessionClosed(head, session);
    }

    private void callNextSessionClosed(Entry entry, ProtocolSession session) {
        try {
            entry.filter.sessionClosed(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        Entry head = this.head;
        this.callNextSessionIdle(head, session, status);
    }

    private void callNextSessionIdle(Entry entry, ProtocolSession session, IdleStatus status) {
        try {
            entry.filter.sessionIdle(entry.nextFilter, session, status);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void messageReceived(ProtocolSession session, Object message) {
        Entry head = this.head;
        this.callNextMessageReceived(head, session, message);
    }

    private void callNextMessageReceived(Entry entry, ProtocolSession session, Object message) {
        try {
            entry.filter.messageReceived(entry.nextFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
        Entry head = this.head;
        this.callNextMessageSent(head, session, message);
    }

    private void callNextMessageSent(Entry entry, ProtocolSession session, Object message) {
        try {
            entry.filter.messageSent(entry.nextFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        Entry head = this.head;
        this.callNextExceptionCaught(head, session, cause);
    }

    private void callNextExceptionCaught(Entry entry, ProtocolSession session, Throwable cause) {
        try {
            entry.filter.exceptionCaught(entry.nextFilter, session, cause);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void filterWrite(ProtocolSession session, Object message) {
        Entry tail = this.tail;
        this.callPreviousFilterWrite(tail, session, message);
    }

    private void callPreviousFilterWrite(Entry entry, ProtocolSession session, Object message) {
        if (message == null) {
            return;
        }
        try {
            entry.filter.filterWrite(entry.prevFilter, session, message);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public List getChildren() {
        ArrayList<ProtocolHandlerFilter> list = new ArrayList<ProtocolHandlerFilter>();
        Entry e = this.head.nextEntry;
        while (e != this.tail) {
            list.add(e.filter);
            e = e.nextEntry;
        }
        return list;
    }

    public List getChildrenReversed() {
        ArrayList<ProtocolHandlerFilter> list = new ArrayList<ProtocolHandlerFilter>();
        Entry e = this.tail.prevEntry;
        while (e != this.head) {
            list.add(e.filter);
            e = e.prevEntry;
        }
        return list;
    }

    protected abstract void doWrite(ProtocolSession var1, Object var2);

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final ProtocolHandlerFilter filter;
        private final ProtocolHandlerFilter.NextFilter nextFilter;
        private final ProtocolHandlerFilter.NextFilter prevFilter;

        private Entry(Entry prevEntry, Entry nextEntry, String name, ProtocolHandlerFilter filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.name = name;
            this.filter = filter;
            this.nextFilter = new ProtocolHandlerFilter.NextFilter(){

                public void sessionOpened(ProtocolSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextSessionOpened(nextEntry, session);
                }

                public void sessionClosed(ProtocolSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextSessionClosed(nextEntry, session);
                }

                public void sessionIdle(ProtocolSession session, IdleStatus status) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextSessionIdle(nextEntry, session, status);
                }

                public void exceptionCaught(ProtocolSession session, Throwable cause) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextExceptionCaught(nextEntry, session, cause);
                }

                public void messageReceived(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextMessageReceived(nextEntry, session, message);
                }

                public void messageSent(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractProtocolHandlerFilterChain.this.callNextMessageSent(nextEntry, session, message);
                }

                public void filterWrite(ProtocolSession session, Object message) {
                    throw new IllegalStateException();
                }
            };
            this.prevFilter = new ProtocolHandlerFilter.NextFilter(){

                public void sessionOpened(ProtocolSession session) {
                    throw new IllegalStateException();
                }

                public void sessionClosed(ProtocolSession session) {
                    throw new IllegalStateException();
                }

                public void sessionIdle(ProtocolSession session, IdleStatus status) {
                    throw new IllegalStateException();
                }

                public void exceptionCaught(ProtocolSession session, Throwable cause) {
                    throw new IllegalStateException();
                }

                public void messageReceived(ProtocolSession session, Object message) {
                    throw new IllegalStateException();
                }

                public void messageSent(ProtocolSession session, Object message) {
                    throw new IllegalStateException();
                }

                public void filterWrite(ProtocolSession session, Object message) {
                    Entry nextEntry = Entry.this.prevEntry;
                    AbstractProtocolHandlerFilterChain.this.callPreviousFilterWrite(nextEntry, session, message);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public ProtocolHandlerFilter getFilter() {
            return this.filter;
        }
    }
}

