/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.codec;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolCodecFactory;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolDecoderOutput;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolEncoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;
import org.apache.mina.protocol.codec.CumulativeProtocolDecoder;
import org.apache.mina.protocol.codec.MessageDecoder;
import org.apache.mina.protocol.codec.MessageDecoderResult;
import org.apache.mina.protocol.codec.MessageEncoder;

public class DemuxingProtocolCodecFactory
implements ProtocolCodecFactory {
    private MessageDecoder[] decoders = new MessageDecoder[0];
    private final Map encoders = new HashMap();
    private final ProtocolEncoder protocolEncoder = new ProtocolEncoderImpl();
    private final ProtocolDecoder protocolDecoder = new ProtocolDecoderImpl();

    public void register(MessageEncoder encoder) {
        Iterator it = encoder.getMessageTypes().iterator();
        while (it.hasNext()) {
            Class type = (Class)it.next();
            this.encoders.put(type, encoder);
        }
    }

    public void register(MessageDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        MessageDecoder[] decoders = this.decoders;
        MessageDecoder[] newDecoders = new MessageDecoder[decoders.length + 1];
        System.arraycopy(decoders, 0, newDecoders, 0, decoders.length);
        newDecoders[decoders.length] = decoder;
        this.decoders = newDecoders;
    }

    public ProtocolEncoder newEncoder() {
        return this.protocolEncoder;
    }

    public ProtocolDecoder newDecoder() {
        return this.protocolDecoder;
    }

    private class ProtocolDecoderImpl
    extends CumulativeProtocolDecoder {
        private MessageDecoder currentDecoder;

        protected ProtocolDecoderImpl() {
            super(16);
        }

        protected boolean doDecode(ProtocolSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolViolationException {
            MessageDecoderResult result;
            if (this.currentDecoder == null) {
                MessageDecoder[] decoders = DemuxingProtocolCodecFactory.this.decoders;
                int undecodables = 0;
                for (int i = decoders.length - 1; i >= 0; --i) {
                    MessageDecoder decoder = decoders[i];
                    int limit = in.limit();
                    in.position(0);
                    MessageDecoderResult result2 = decoder.decodable(session, in);
                    in.position(0);
                    in.limit(limit);
                    if (result2 == MessageDecoder.OK) {
                        this.currentDecoder = decoder;
                        break;
                    }
                    if (result2 == MessageDecoder.NOT_OK) {
                        ++undecodables;
                        continue;
                    }
                    if (result2 == MessageDecoder.NEED_DATA) continue;
                    throw new IllegalStateException("Unexpected decode result (see your decodable()): " + result2);
                }
                if (undecodables == decoders.length) {
                    in.position(in.limit());
                    throw new ProtocolViolationException("No appropriate message decoder: " + in.getHexDump());
                }
                if (this.currentDecoder == null) {
                    return false;
                }
            }
            if ((result = this.currentDecoder.decode(session, in, out)) == MessageDecoder.OK) {
                this.currentDecoder = null;
                return true;
            }
            if (result == MessageDecoder.NEED_DATA) {
                return false;
            }
            if (result == MessageDecoder.NOT_OK) {
                throw new ProtocolViolationException("Message decoder returned NOT_OK.");
            }
            throw new IllegalStateException("Unexpected decode result (see your decode()): " + result);
        }
    }

    private class ProtocolEncoderImpl
    implements ProtocolEncoder {
        private ProtocolEncoderImpl() {
        }

        public void encode(ProtocolSession session, Object message, ProtocolEncoderOutput out) throws ProtocolViolationException {
            Class<?> type = message.getClass();
            MessageEncoder encoder = this.findEncoder(type);
            if (encoder == null) {
                throw new ProtocolViolationException("Unexpected message type: " + type);
            }
            encoder.encode(session, message, out);
        }

        private MessageEncoder findEncoder(Class type) {
            MessageEncoder encoder = (MessageEncoder)DemuxingProtocolCodecFactory.this.encoders.get(type);
            if (encoder == null) {
                encoder = this.findEncoder(type, new HashSet());
            }
            return encoder;
        }

        private MessageEncoder findEncoder(Class type, Set triedClasses) {
            if (triedClasses.contains(type)) {
                return null;
            }
            triedClasses.add(type);
            MessageEncoder encoder = (MessageEncoder)DemuxingProtocolCodecFactory.this.encoders.get(type);
            if (encoder == null) {
                encoder = this.findEncoder(type, triedClasses);
                if (encoder != null) {
                    return encoder;
                }
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    encoder = this.findEncoder(interfaces[i], triedClasses);
                    if (encoder == null) continue;
                    return encoder;
                }
                return null;
            }
            return encoder;
        }
    }
}

