/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.BaseSessionManager;
import org.apache.mina.protocol.ProtocolConnector;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.vmpipe.AnonymousVmPipeAddress;
import org.apache.mina.protocol.vmpipe.VmPipeAcceptor;
import org.apache.mina.protocol.vmpipe.VmPipeAddress;
import org.apache.mina.protocol.vmpipe.VmPipeFilter;
import org.apache.mina.protocol.vmpipe.VmPipeIdleStatusChecker;
import org.apache.mina.protocol.vmpipe.VmPipeSession;
import org.apache.mina.protocol.vmpipe.VmPipeSessionManagerFilterChain;

public class VmPipeConnector
extends BaseSessionManager
implements ProtocolConnector {
    private final VmPipeSessionManagerFilterChain filterChain = new VmPipeSessionManagerFilterChain(this);

    public VmPipeConnector() {
        this.filterChain.addFirst("VMPipe", new VmPipeFilter());
    }

    public ProtocolFilterChain getFilterChain() {
        return this.filterChain;
    }

    public ProtocolSession connect(SocketAddress address, ProtocolProvider protocolProvider) throws IOException {
        return this.connect(address, null, Integer.MAX_VALUE, protocolProvider);
    }

    public ProtocolSession connect(SocketAddress address, SocketAddress localAddress, ProtocolProvider protocolProvider) throws IOException {
        return this.connect(address, localAddress, Integer.MAX_VALUE, protocolProvider);
    }

    public ProtocolSession connect(SocketAddress address, int timeout, ProtocolProvider protocolProvider) throws IOException {
        return this.connect(address, null, timeout, protocolProvider);
    }

    public ProtocolSession connect(SocketAddress address, SocketAddress localAddress, int timeout, ProtocolProvider protocolProvider) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (protocolProvider == null) {
            throw new NullPointerException("protocolProvider");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        VmPipeAcceptor.Entry entry = (VmPipeAcceptor.Entry)VmPipeAcceptor.boundHandlers.get(address);
        if (entry == null) {
            throw new IOException("Endpoint unavailable: " + address);
        }
        VmPipeSession session = new VmPipeSession(new Object(), AnonymousVmPipeAddress.INSTANCE, this.filterChain, protocolProvider.getHandler(), entry);
        VmPipeIdleStatusChecker.INSTANCE.addSession(session);
        return session;
    }
}

