/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder;

import javax.naming.directory.ModificationItem;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.encoder.AttributeEncoder;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;

public class ModificationItemEncoder {
    public static final ModificationItemEncoder INSTANCE = new ModificationItemEncoder();

    public TupleNode encode(ModificationItem item) {
        DefaultMutableTupleNode child = null;
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)UniversalTag.ENUMERATED, this.getLdapModOp(item.getModificationOp()));
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        child = (DefaultMutableTupleNode)AttributeEncoder.INSTANCE.encode(item.getAttribute());
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        return top;
    }

    private int getLdapModOp(int jndiModOp) {
        switch (jndiModOp) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unrecognized JNDI ModificationItem operation");
    }
}

