/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.bind;

import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.commons.lang.NotImplementedException;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.berlib.asn1.encoder.LdapResultEncoder;
import org.apache.ldap.common.message.BindResponse;

public class BindResponseEncoder {
    public static final BindResponseEncoder INSTANCE = new BindResponseEncoder();

    public TupleNode encode(BindResponse response) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(response.getMessageId());
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        DefaultMutableTupleNode bindresp = new DefaultMutableTupleNode(new Tuple());
        bindresp.getTuple().setTag((TagEnum)LdapTag.BIND_RESPONSE, false);
        bindresp.getTuple().setLength(-2);
        LdapResultEncoder.INSTANCE.encode(bindresp, response.getLdapResult());
        if (response.getServerSaslCreds() != null) {
            throw new NotImplementedException("SASL binds not implemented");
        }
        top.addLast(bindresp);
        bindresp.setParent((MutableTupleNode)top);
        return top;
    }
}

