/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.modify;

import java.util.Iterator;
import javax.naming.directory.ModificationItem;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.berlib.asn1.encoder.ModificationItemEncoder;
import org.apache.ldap.common.message.ModifyRequest;

public class ModifyRequestEncoder {
    public static final ModifyRequestEncoder INSTANCE = new ModifyRequestEncoder();

    public TupleNode encode(ModifyRequest request) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getMessageId());
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        DefaultMutableTupleNode modReq = new DefaultMutableTupleNode(new Tuple());
        modReq.getTuple().setTag((TagEnum)LdapTag.MODIFY_REQUEST, false);
        modReq.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getName());
        modReq.addLast(child);
        child.setParent((MutableTupleNode)modReq);
        DefaultMutableTupleNode mods = new DefaultMutableTupleNode(new Tuple());
        mods.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        mods.getTuple().setLength(-2);
        Iterator list = request.getModificationItems().iterator();
        while (list.hasNext()) {
            ModificationItem item = (ModificationItem)list.next();
            DefaultMutableTupleNode itemNode = (DefaultMutableTupleNode)ModificationItemEncoder.INSTANCE.encode(item);
            mods.addLast(itemNode);
            itemNode.setParent((MutableTupleNode)mods);
        }
        modReq.addLast(mods);
        mods.setParent((MutableTupleNode)modReq);
        top.addLast(modReq);
        modReq.setParent((MutableTupleNode)top);
        return top;
    }
}

