/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.exception;

import javax.naming.AuthenticationNotSupportedException;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.ResultCodeEnum;

public class LdapAuthenticationNotSupportedException
extends AuthenticationNotSupportedException
implements LdapException {
    private final ResultCodeEnum resultCode;

    public LdapAuthenticationNotSupportedException(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.checkResultCode();
    }

    public LdapAuthenticationNotSupportedException(String explanation, ResultCodeEnum resultCode) {
        super(explanation);
        this.resultCode = resultCode;
        this.checkResultCode();
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    private void checkResultCode() {
        switch (this.resultCode.getValue()) {
            case 48: {
                break;
            }
            case 13: {
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexceptable result code for this exception type: " + this.resultCode.getName());
            }
        }
    }
}

