/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import antlr.LexerSharedInputState;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import org.apache.ldap.common.filter.AntlrFilterLexer;
import org.apache.ldap.common.filter.AntlrFilterParser;
import org.apache.ldap.common.filter.AntlrFilterValueLexer;
import org.apache.ldap.common.filter.AntlrFilterValueParser;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterParser;
import org.apache.ldap.common.filter.FilterParserMonitor;
import org.apache.ldap.common.util.StringTools;

public class FilterParserImpl
implements FilterParser {
    private AntlrFilterParser parser;
    private PipedOutputStream parserPipe;
    private AntlrFilterLexer lexer;
    private TokenStreamSelector selector;
    private LexerSharedInputState state;
    private AntlrFilterValueLexer valueLexer;
    private AntlrFilterValueParser valueParser;

    public FilterParserImpl() {
        this.init();
    }

    private synchronized void init() {
        this.parserPipe = new PipedOutputStream();
        PipedInputStream pipeTail = new PipedInputStream();
        try {
            this.parserPipe.connect(pipeTail);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.state = new LexerSharedInputState((InputStream)pipeTail);
        this.lexer = new AntlrFilterLexer(this.state);
        this.valueLexer = new AntlrFilterValueLexer(this.state);
        this.selector = new TokenStreamSelector();
        this.selector.addInputStream((TokenStream)this.lexer, "filterLexer");
        this.selector.addInputStream((TokenStream)this.valueLexer, "filterValueLexer");
        this.selector.select((TokenStream)this.lexer);
        this.parser = new AntlrFilterParser((TokenStream)this.selector);
        this.parser.setSelector(this.selector);
        this.parser.setValueLexer(this.valueLexer);
        this.parser.setValueParser(this.valueParser);
        this.valueParser = new AntlrFilterValueParser((TokenStream)this.selector);
        this.valueParser.setSelector(this.selector);
        this.valueParser.setLexer(this.lexer);
        this.parser.setValueParser(this.valueParser);
    }

    public synchronized ExprNode parse(String filter) throws ParseException, IOException {
        ExprNode root = null;
        if (filter == null || filter.trim().equals("")) {
            return null;
        }
        if (filter.indexOf("**") > -1) {
            filter = StringTools.trimConsecutiveToOne(filter, '*');
        }
        this.parserPipe.write(filter.getBytes());
        this.parserPipe.write(10);
        this.parserPipe.flush();
        try {
            root = this.parser.filter();
            this.state.reset();
            this.selector.select((TokenStream)this.lexer);
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on filter:\n\t" + filter;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            this.init();
            throw new ParseException(msg, e.getColumn());
        }
        catch (TokenStreamException e2) {
            String msg = "Parser failure on filter:\n\t" + filter;
            msg = msg + "\nAntlr exception trace:\n" + e2.getMessage();
            this.init();
            throw new ParseException(msg, 0);
        }
        return root;
    }

    public void setFilterParserMonitor(FilterParserMonitor monitor) {
        this.parser.setFilterParserMonitor(monitor);
        this.valueParser.setFilterParserMonitor(monitor);
    }
}

