/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import org.apache.ldap.common.message.AbstractRequest;
import org.apache.ldap.common.message.ExtendedRequest;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.util.ArrayUtils;

public class ExtendedRequestImpl
extends AbstractRequest
implements ExtendedRequest {
    private String oid;
    private byte[] payload;

    public ExtendedRequestImpl(int id) {
        super(id, TYPE, true);
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.lockCheck("Attempt to alter OID of locked ExtendedRequest!");
        this.oid = oid;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.lockCheck("Attempt to alter payload of locked ExtendedRequest!");
        this.payload = payload;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ExtendedRequest req = (ExtendedRequest)obj;
        if (this.oid != null && req.getOid() == null) {
            return false;
        }
        if (this.oid == null && req.getOid() != null) {
            return false;
        }
        if (this.oid != null && req.getOid() != null && !this.oid.equals(req.getOid())) {
            return false;
        }
        if (this.payload != null && req.getPayload() == null) {
            return false;
        }
        if (this.payload == null && req.getPayload() != null) {
            return false;
        }
        return this.payload == null || req.getPayload() == null || ArrayUtils.isEquals(this.payload, req.getPayload());
    }
}

