/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.io.InputStream;
import java.util.Hashtable;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderDecoder;
import org.apache.ldap.common.message.spi.TransformerSpi;

public final class MessageDecoder
implements ProviderDecoder {
    private final Hashtable env;
    private final Provider provider;
    private final ProviderDecoder decoder;
    private final TransformerSpi transformer;
    private DecoderCallback cb;

    public MessageDecoder() throws MessageException {
        this(Provider.getEnvironment());
    }

    public MessageDecoder(Hashtable env) throws MessageException {
        this.env = (Hashtable)env.clone();
        this.provider = Provider.getProvider(this.env);
        this.decoder = this.provider.getDecoder();
        this.transformer = this.provider.getTransformer();
        this.decoder.setCallback(new DecoderCallback(){

            public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
                MessageDecoder.this.cb.decodeOccurred(decoder, (Object)MessageDecoder.this.transformer.transform(decoded));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws MessageException {
        Object providerEnvelope = null;
        if (lock == null) {
            providerEnvelope = this.decoder.decode(lock, in);
        } else {
            Object object = lock;
            synchronized (object) {
                providerEnvelope = this.decoder.decode(lock, in);
                lock.notifyAll();
            }
        }
        Message message = this.transformer.transform(providerEnvelope);
        message.setLocked(true);
        return message;
    }

    public void decode(Object chunk) throws MessageException {
        try {
            this.decoder.decode(chunk);
        }
        catch (DecoderException e) {
            throw new MessageException("decoder failture: " + e.getMessage());
        }
    }

    public void setCallback(DecoderCallback cb) {
        this.cb = cb;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.decoder.setDecoderMonitor(monitor);
    }

    public Provider getProvider() {
        return this.provider;
    }
}

