/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderEncoder;
import org.apache.ldap.common.message.spi.ProviderException;
import org.apache.ldap.common.message.spi.TransformerSpi;

public final class MessageEncoder
implements ProviderEncoder {
    private final Provider provider;
    private final ProviderEncoder encoder;
    private final TransformerSpi transformer;

    public MessageEncoder() throws MessageException {
        this(Provider.getEnvironment());
    }

    public MessageEncoder(Hashtable env) throws MessageException {
        this.provider = Provider.getProvider((Hashtable)env.clone());
        this.encoder = this.provider.getEncoder();
        this.transformer = this.provider.getTransformer();
    }

    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        Object providerEnvelope = this.transformer.transform((Message)obj);
        this.encoder.encodeBlocking(lock, out, providerEnvelope);
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        Object providerEnvelope = this.transformer.transform((Message)obj);
        return this.encoder.encodeBlocking(providerEnvelope);
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        Object providerEnvelope = this.transformer.transform((Message)obj);
        this.encoder.encode(providerEnvelope);
    }

    public void setCallback(EncoderCallback cb) {
        this.encoder.setCallback(cb);
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.encoder.setEncoderMonitor(monitor);
    }
}

