/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.Referral;

public class ReferralImpl
extends AbstractLockable
implements Referral {
    private final HashSet urls = new HashSet();

    public ReferralImpl(Lockable parent) {
        super(parent, false);
    }

    public Collection getLdapUrls() {
        return Collections.unmodifiableCollection(this.urls);
    }

    public void addLdapUrl(String url) {
        this.lockCheck("Atempt to add alternative url to locked Referral!");
        this.urls.add(url);
    }

    public void removeLdapUrl(String url) {
        this.lockCheck("Atempt to remove alternative url from locked Referral!");
        this.urls.remove(url);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Referral) {
            Collection refs = ((Referral)obj).getLdapUrls();
            if (refs.size() != this.urls.size()) {
                return false;
            }
            Iterator list = this.urls.iterator();
            while (list.hasNext()) {
                if (refs.contains(list.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

