/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.asn1.ber.digester.Rule;
import org.apache.asn1.ber.digester.RuleRegistration;
import org.apache.asn1.ber.digester.TagNode;
import org.apache.commons.collections.primitives.IntStack;
import org.apache.commons.lang.Validate;

public class TagTree {
    public static final int WILDCARD = 0x1FFFFFFF;
    private HashMap normNodes = new HashMap(3);
    private HashMap wildNodes = new HashMap(3);
    private ArrayList normRegistrations = new ArrayList();
    private ArrayList wildRegistrations = new ArrayList();

    public void addRule(int[] pattern, Rule rule) {
        if (pattern[0] == 0x1FFFFFFF) {
            this.wildRegistrations.add(new RuleRegistration(pattern, rule));
            this.addWildRule(pattern, rule);
        } else {
            this.normRegistrations.add(new RuleRegistration(pattern, rule));
            this.addNormalRule(pattern, rule);
        }
    }

    private void addNormalRule(int[] pattern, Rule rule) {
        Integer tag = null;
        TagNode node = null;
        Stack<Integer> stack = new Stack<Integer>();
        Validate.notNull(rule, "cannot add null rule");
        Validate.notNull(pattern, "cannot add rule with null pattern");
        Validate.isTrue(pattern.length > 0, "cannot add rule with empty pattern");
        tag = new Integer(pattern[0]);
        if (this.normNodes.containsKey(tag)) {
            node = (TagNode)this.normNodes.get(tag);
            stack.push(node.getTag());
        } else {
            node = new TagNode(tag);
            this.normNodes.put(tag, node);
            stack.push(node.getTag());
            this.addWildRulesToNewNormalNode(node, stack);
        }
        for (int ii = 1; ii < pattern.length; ++ii) {
            Integer childTag = new Integer(pattern[ii]);
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                childNode = new TagNode(childTag);
                node.addNode(childNode);
                stack.push(childNode.getTag());
                this.addWildRulesToNewNormalNode(childNode, stack);
            } else {
                stack.push(childNode.getTag());
            }
            node = childNode;
            tag = childTag;
        }
        node.addRule(rule);
    }

    private void addWildRule(int[] pattern, Rule rule) {
        Validate.notNull(pattern, "Attempting to register rule " + rule + " with null pattern");
        Validate.isTrue(pattern.length > 0, "Attempting to register rule " + rule + " with zero length pattern");
        Validate.isTrue(pattern[0] == 0x1FFFFFFF, "Expected rule " + rule + " pattern to have front wild card but it did not");
        Validate.isTrue(pattern.length > 1, "Cannot register only wild card \"*\" pattern for rule " + rule);
        TagNode node = null;
        Iterator list = this.normNodes.values().iterator();
        while (list.hasNext()) {
            node = (TagNode)list.next();
            this.addWildRuleToNormalTree(pattern, rule, new Stack(), node);
        }
        Integer tag = new Integer(pattern[pattern.length - 1]);
        if (this.wildNodes.containsKey(tag)) {
            node = (TagNode)this.wildNodes.get(tag);
        } else {
            node = new TagNode(tag);
            this.wildNodes.put(tag, node);
        }
        for (int ii = pattern.length - 2; ii >= 1; --ii) {
            Integer childTag = new Integer(pattern[ii]);
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                childNode = new TagNode(childTag);
                node.addNode(childNode);
            }
            node = childNode;
            tag = childTag;
        }
        list = this.wildNodes.values().iterator();
        while (list.hasNext()) {
            node = (TagNode)list.next();
            this.addWildRuleToWildTree(pattern, rule, new Stack(), node);
        }
    }

    private void addWildRulesToNewNormalNode(TagNode node, Stack stack) {
        for (int jj = 0; jj < this.wildRegistrations.size(); ++jj) {
            RuleRegistration reg = (RuleRegistration)this.wildRegistrations.get(jj);
            if (!this.isTailMatch(reg.getPattern(), stack)) continue;
            node.addRule(reg.getRule());
        }
    }

    private void addWildRuleToWildTree(int[] pattern, Rule rule, Stack stack, TagNode node) {
        stack.push(node.getTag());
        if (this.isReverseTailMatch(pattern, stack) && !node.getRules().contains(rule)) {
            node.addRule(rule);
        }
        if (!node.isLeaf()) {
            Iterator children = node.getChildren();
            while (children.hasNext()) {
                this.addWildRuleToWildTree(pattern, rule, stack, (TagNode)children.next());
            }
        }
        stack.pop();
    }

    private boolean isReverseTailMatch(int[] pattern, Stack stack) {
        if (stack.size() < pattern.length - 1) {
            return false;
        }
        int ii = pattern.length - 1;
        int jj = 0;
        while (ii >= 1) {
            if (pattern[ii] != (Integer)stack.get(jj)) {
                return false;
            }
            --ii;
            ++jj;
        }
        return true;
    }

    private void addWildRuleToNormalTree(int[] pattern, Rule rule, Stack stack, TagNode node) {
        stack.push(node.getTag());
        if (this.isTailMatch(pattern, stack) && node.isLeaf() && !node.getRules().contains(rule)) {
            node.addRule(rule);
        }
        if (!node.isLeaf()) {
            Iterator children = node.getChildren();
            while (children.hasNext()) {
                this.addWildRuleToNormalTree(pattern, rule, stack, (TagNode)children.next());
            }
        }
        stack.pop();
    }

    private boolean isTailMatch(int[] pattern, Stack stack) {
        if (stack.size() < pattern.length - 1) {
            return false;
        }
        int ii = pattern.length - 1;
        int jj = stack.size() - 1;
        while (ii >= 1) {
            if (pattern[ii] != (Integer)stack.get(jj)) {
                return false;
            }
            --ii;
            --jj;
        }
        return true;
    }

    public List match(IntStack stack) {
        TagNode node = this.getNode(stack);
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        return node.getRules();
    }

    public TagNode getNode(IntStack stack) {
        TagNode node = this.getNormalNode(stack);
        if (node == null) {
            node = this.getWildNode(stack);
        }
        return node;
    }

    public List match(int[] pattern) {
        TagNode node = this.getNode(pattern);
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        return node.getRules();
    }

    public TagNode getNode(int[] pattern) {
        TagNode node = this.getNormalNode(pattern);
        if (node == null) {
            node = this.getWildNode(pattern);
        }
        return node;
    }

    private TagNode getNormalNode(IntStack stack) {
        Integer tag = null;
        TagNode node = null;
        Validate.notNull(stack, "cannot match using null pattern");
        Validate.isTrue(!stack.empty(), "cannot match with empty pattern");
        tag = new Integer(stack.get(0));
        if (!this.normNodes.containsKey(tag)) {
            return null;
        }
        node = (TagNode)this.normNodes.get(tag);
        for (int ii = 1; ii < stack.size(); ++ii) {
            Integer childTag = new Integer(stack.get(ii));
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                return null;
            }
            node = childNode;
            tag = childTag;
        }
        return node;
    }

    private TagNode getNormalNode(int[] pattern) {
        Integer tag = null;
        TagNode node = null;
        Validate.notNull(pattern, "cannot match using null pattern");
        Validate.isTrue(pattern.length > 0, "cannot match with empty pattern");
        tag = new Integer(pattern[0]);
        if (!this.normNodes.containsKey(tag)) {
            return null;
        }
        node = (TagNode)this.normNodes.get(tag);
        for (int ii = 1; ii < pattern.length; ++ii) {
            Integer childTag = new Integer(pattern[ii]);
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                return null;
            }
            node = childNode;
            tag = childTag;
        }
        return node;
    }

    private TagNode getWildNode(int[] pattern) {
        Integer tag = null;
        TagNode node = null;
        Validate.notNull(pattern, "cannot match using null pattern");
        Validate.isTrue(pattern.length > 0, "cannot match with empty pattern");
        tag = new Integer(pattern[pattern.length - 1]);
        if (!this.wildNodes.containsKey(tag)) {
            return null;
        }
        node = (TagNode)this.wildNodes.get(tag);
        for (int ii = pattern.length - 2; ii >= 0; --ii) {
            Integer childTag = new Integer(pattern[ii]);
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                return node;
            }
            node = childNode;
            tag = childTag;
        }
        return node;
    }

    private TagNode getWildNode(IntStack stack) {
        Integer tag = null;
        TagNode node = null;
        Validate.notNull(stack, "cannot match using null pattern");
        Validate.isTrue(!stack.empty(), "cannot match with empty pattern");
        tag = new Integer(stack.get(stack.size() - 1));
        if (!this.wildNodes.containsKey(tag)) {
            return null;
        }
        node = (TagNode)this.wildNodes.get(tag);
        for (int ii = stack.size() - 2; ii >= 0; --ii) {
            Integer childTag = new Integer(stack.get(ii));
            TagNode childNode = node.getChild(childTag);
            if (childNode == null) {
                return node;
            }
            node = childNode;
            tag = childTag;
        }
        return node;
    }
}

