/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester.rules;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;

public class PrimitiveBooleanRule
extends AbstractRule {
    private byte value = 0;
    private boolean octetSet = false;
    private final TagEnum tag;

    public PrimitiveBooleanRule() {
        this.tag = UniversalTag.BOOLEAN;
    }

    public PrimitiveBooleanRule(TagEnum tag) {
        this.tag = tag;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        if (id != this.tag.getTagId()) {
            throw new IllegalArgumentException("Expecting " + this.tag.getName() + " with an id of " + this.tag.getTagId() + " but instead got a tag id of " + id);
        }
    }

    public void length(int length) {
        if (length != 1) {
            throw new IllegalArgumentException("The target primitive for this rule only requires a single octet with a length of 1.  The length of the field however is " + length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.octetSet) {
            throw new IllegalArgumentException("The target primitive for this rule only requires a single octet with a length of 1.  That octet has already been set.");
        }
        while (buf.hasRemaining()) {
            this.value = buf.get();
            this.octetSet = true;
        }
    }

    public void finish() {
        if (this.getDigester() != null) {
            this.getDigester().pushBoolean(PrimitiveUtils.berDecodeBoolean(this.value));
        }
        this.value = 0;
        this.octetSet = false;
    }
}

