/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;

public abstract class AbstractBooleanCollection
implements BooleanCollection {
    public abstract BooleanIterator iterator();

    public abstract int size();

    protected AbstractBooleanCollection() {
    }

    public boolean add(boolean element) {
        throw new UnsupportedOperationException("add(boolean) is not supported.");
    }

    public boolean addAll(BooleanCollection c) {
        boolean modified = false;
        BooleanIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    public void clear() {
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public boolean contains(boolean element) {
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BooleanCollection c) {
        BooleanIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public boolean removeElement(boolean element) {
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(BooleanCollection c) {
        boolean modified = false;
        BooleanIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    public boolean retainAll(BooleanCollection c) {
        boolean modified = false;
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int i = 0;
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public boolean[] toArray(boolean[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

