/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import org.apache.commons.collections.primitives.ArrayBooleanList;

public class BooleanStack {
    private ArrayBooleanList list = new ArrayBooleanList();

    public BooleanStack() {
    }

    public BooleanStack(boolean[] bits) {
        for (int ii = 0; ii < bits.length; ++ii) {
            this.list.add(bits[ii]);
        }
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public boolean peek() {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.get(this.list.size() - 1);
    }

    public boolean peek(int n) {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.get(this.list.size() - n - 1);
    }

    public boolean pop() {
        if (this.list.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.list.removeElementAt(this.list.size() - 1);
    }

    public boolean push(boolean item) {
        this.list.add(item);
        return item;
    }

    public int search(boolean item) {
        for (int ii = this.list.size() - 1; ii >= 0; --ii) {
            if (this.list.get(ii) != item) continue;
            return this.list.size() - ii;
        }
        return -1;
    }

    public boolean get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }
}

