/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractBooleanCollection;
import org.apache.commons.collections.primitives.BooleanCollection;
import org.apache.commons.collections.primitives.BooleanIterator;
import org.apache.commons.collections.primitives.BooleanList;
import org.apache.commons.collections.primitives.BooleanListIterator;

public abstract class RandomAccessBooleanList
extends AbstractBooleanCollection
implements BooleanList {
    private int _modCount = 0;

    protected RandomAccessBooleanList() {
    }

    public abstract boolean get(int var1);

    public abstract int size();

    public boolean removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean set(int index, boolean element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, boolean element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(boolean element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(int index, BooleanCollection collection) {
        boolean modified = false;
        BooleanIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    public int indexOf(boolean element) {
        int i = 0;
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(boolean element) {
        BooleanListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public BooleanIterator iterator() {
        return this.listIterator();
    }

    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    public BooleanListIterator listIterator(int index) {
        return new RandomAccessBooleanListIterator(this, index);
    }

    public BooleanList subList(int fromIndex, int toIndex) {
        return new RandomAccessBooleanSubList(this, fromIndex, toIndex);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof BooleanList) {
            BooleanList thatList = (BooleanList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            BooleanIterator thatIter = thatList.iterator();
            BooleanIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            hash = 31 * hash + (iter.next() ? 1231 : 1237);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        BooleanIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessBooleanSubList
    extends RandomAccessBooleanList
    implements BooleanList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessBooleanList _list = null;
        private ComodChecker _comod = null;

        RandomAccessBooleanSubList(RandomAccessBooleanList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        public boolean get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        public boolean removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            boolean val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        public boolean set(int index, boolean element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            boolean val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        public void add(int index, boolean element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }

    protected static class RandomAccessBooleanListIterator
    extends ComodChecker
    implements BooleanListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessBooleanListIterator(RandomAccessBooleanList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        public boolean next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            boolean val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        public boolean previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            boolean val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        public void add(boolean value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        public void set(boolean value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessBooleanList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessBooleanList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessBooleanList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

