/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.messages.value.AuthorizationData;
import org.apache.kerberos.messages.value.AuthorizationDataEntry;
import org.apache.kerberos.messages.value.AuthorizationType;

public class AuthorizationDataDecoder {
    public AuthorizationData decode(byte[] encodedAuthData) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedAuthData);
        DERSequence sequence = (DERSequence)ais.readObject();
        return AuthorizationDataDecoder.decodeSequence(sequence);
    }

    protected static AuthorizationData decodeSequence(DERSequence sequence) {
        AuthorizationData authData = new AuthorizationData();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERSequence object = (DERSequence)e.nextElement();
            AuthorizationDataEntry entry = AuthorizationDataDecoder.decodeAuthorizationEntry(object);
            authData.add(entry);
        }
        return authData;
    }

    protected static AuthorizationDataEntry decodeAuthorizationEntry(DERSequence sequence) {
        AuthorizationType type = AuthorizationType.NULL;
        byte[] data = null;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = AuthorizationType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DEROctetString tag1 = (DEROctetString)derObject;
                    data = tag1.getOctets();
                }
            }
        }
        return new AuthorizationDataEntry(type, data);
    }
}

