/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.asn1.der.ASN1InputStream;
import org.apache.asn1.der.DERApplicationSpecific;
import org.apache.asn1.der.DERBitString;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERGeneralString;
import org.apache.asn1.der.DERGeneralizedTime;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.io.decoder.AuthorizationDataDecoder;
import org.apache.kerberos.io.decoder.EncryptionKeyDecoder;
import org.apache.kerberos.io.decoder.HostAddressDecoder;
import org.apache.kerberos.io.decoder.KerberosTimeDecoder;
import org.apache.kerberos.io.decoder.PrincipalNameDecoder;
import org.apache.kerberos.messages.components.EncTicketPart;
import org.apache.kerberos.messages.components.EncTicketPartModifier;
import org.apache.kerberos.messages.value.TicketFlags;
import org.apache.kerberos.messages.value.TransitedEncoding;
import org.apache.kerberos.messages.value.TransitedEncodingType;

public class EncTicketPartDecoder {
    public EncTicketPart decode(byte[] encodedTicket) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedTicket);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence sequence = (DERSequence)app.getObject();
        return this.decodeEncTicketPartSequence(sequence);
    }

    private EncTicketPart decodeEncTicketPartSequence(DERSequence sequence) {
        EncTicketPartModifier modifier = new EncTicketPartModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERBitString tag0 = (DERBitString)derObject;
                    modifier.setFlags(new TicketFlags(tag0.getOctets()));
                    break;
                }
                case 1: {
                    DERSequence tag1 = (DERSequence)derObject;
                    modifier.setSessionKey(EncryptionKeyDecoder.decode(tag1));
                    break;
                }
                case 2: {
                    DERGeneralString tag2 = (DERGeneralString)derObject;
                    modifier.setClientRealm(tag2.getString());
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    modifier.setClientName(PrincipalNameDecoder.decode(tag3));
                    break;
                }
                case 4: {
                    DERSequence tag4 = (DERSequence)derObject;
                    modifier.setTransitedEncoding(this.decodeTransitedEncoding(tag4));
                    break;
                }
                case 5: {
                    DERGeneralizedTime tag5 = (DERGeneralizedTime)derObject;
                    modifier.setAuthTime(KerberosTimeDecoder.decode(tag5));
                    break;
                }
                case 6: {
                    DERGeneralizedTime tag6 = (DERGeneralizedTime)derObject;
                    modifier.setStartTime(KerberosTimeDecoder.decode(tag6));
                    break;
                }
                case 7: {
                    DERGeneralizedTime tag7 = (DERGeneralizedTime)derObject;
                    modifier.setEndTime(KerberosTimeDecoder.decode(tag7));
                    break;
                }
                case 8: {
                    DERGeneralizedTime tag8 = (DERGeneralizedTime)derObject;
                    modifier.setRenewTill(KerberosTimeDecoder.decode(tag8));
                    break;
                }
                case 9: {
                    DERSequence tag9 = (DERSequence)derObject;
                    modifier.setClientAddresses(HostAddressDecoder.decodeSequence(tag9));
                    break;
                }
                case 10: {
                    DERSequence tag10 = (DERSequence)derObject;
                    modifier.setAuthorizationData(AuthorizationDataDecoder.decodeSequence(tag10));
                }
            }
        }
        return modifier.getEncTicketPart();
    }

    protected TransitedEncoding decodeTransitedEncoding(DERSequence sequence) {
        TransitedEncodingType type = TransitedEncodingType.NULL;
        byte[] contents = null;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    type = TransitedEncodingType.getTypeByOrdinal(tag0.intValue());
                    break;
                }
                case 1: {
                    DEROctetString tag1 = (DEROctetString)derObject;
                    contents = tag1.getOctets();
                }
            }
        }
        return new TransitedEncoding(type, contents);
    }
}

