/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asn1.der.ASN1OutputStream;
import org.apache.asn1.der.DEREncodable;
import org.apache.asn1.der.DERInteger;
import org.apache.asn1.der.DEROctetString;
import org.apache.asn1.der.DERSequence;
import org.apache.asn1.der.DERTaggedObject;
import org.apache.kerberos.messages.value.EncryptedData;

public class EncryptedDataEncoder {
    public static byte[] encode(EncryptedData encryptedData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)EncryptedDataEncoder.encodeSequence(encryptedData));
        aos.close();
        return baos.toByteArray();
    }

    public static DERSequence encodeSequence(EncryptedData encryptedData) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)encryptedData.getEncryptionType().getOrdinal())));
        if (encryptedData.getKeyVersion() > 0) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)encryptedData.getKeyVersion())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(encryptedData.getCipherText())));
        return sequence;
    }
}

