/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.kdc.replay;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.kdc.replay.ReplayCache;
import org.apache.kerberos.messages.value.KerberosTime;

public class InMemoryReplayCache
implements ReplayCache {
    private static final long TWO_WEEKS = 1209600000L;
    private List list = new ArrayList();

    public synchronized boolean isReplay(KerberosTime clientTime, KerberosPrincipal clientPrincipal) {
        ReplayCacheEntry testEntry = new ReplayCacheEntry(clientTime, clientPrincipal);
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            ReplayCacheEntry entry = (ReplayCacheEntry)it.next();
            if (!entry.equals(testEntry)) continue;
            return true;
        }
        return false;
    }

    public synchronized void save(KerberosTime clientTime, KerberosPrincipal clientPrincipal) {
        this.list.add(new ReplayCacheEntry(clientTime, clientPrincipal));
        this.purgeExpired();
    }

    private synchronized void purgeExpired() {
        long now = new Date().getTime();
        KerberosTime age = new KerberosTime(now - 1209600000L);
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            ReplayCacheEntry entry = (ReplayCacheEntry)it.next();
            if (!entry.olderThan(age)) continue;
            this.list.remove(entry);
        }
    }

    private class ReplayCacheEntry {
        private KerberosTime _clientTime;
        private KerberosPrincipal _clientPrincipal;

        public ReplayCacheEntry(KerberosTime time, KerberosPrincipal principal) {
            this._clientTime = time;
            this._clientPrincipal = principal;
        }

        public boolean equals(ReplayCacheEntry other) {
            return this._clientTime.equals(other._clientTime) && this._clientPrincipal.equals(other._clientPrincipal);
        }

        public boolean olderThan(KerberosTime time) {
            return time.greaterThan(this._clientTime);
        }
    }
}

