/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.messages.value.AuthorizationData;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.HostAddresses;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.messages.value.TicketFlags;
import org.apache.kerberos.messages.value.TransitedEncoding;

public class EncTicketPart {
    private TicketFlags _flags;
    private EncryptionKey _sessionKey;
    private KerberosPrincipal _clientPrincipal;
    private TransitedEncoding _transitedEncoding;
    private KerberosTime _authtime;
    private KerberosTime _startTime;
    private KerberosTime _endTime;
    private KerberosTime _renewTill;
    private HostAddresses _clientAddresses;
    private AuthorizationData _authorizationData;

    public EncTicketPart(TicketFlags flags, EncryptionKey key, KerberosPrincipal clientPrincipal, TransitedEncoding transited, KerberosTime authtime, KerberosTime starttime, KerberosTime endtime, KerberosTime renewTill, HostAddresses caddr, AuthorizationData authorizationData) {
        this._flags = flags;
        this._sessionKey = key;
        this._clientPrincipal = clientPrincipal;
        this._transitedEncoding = transited;
        this._authtime = authtime;
        this._startTime = starttime;
        this._endTime = endtime;
        this._renewTill = renewTill;
        this._clientAddresses = caddr;
        this._authorizationData = authorizationData;
    }

    public AuthorizationData getAuthorizationData() {
        return this._authorizationData;
    }

    public KerberosTime getAuthTime() {
        return this._authtime;
    }

    public HostAddresses getClientAddresses() {
        return this._clientAddresses;
    }

    public KerberosPrincipal getClientPrincipal() {
        return this._clientPrincipal;
    }

    public String getClientRealm() {
        return this._clientPrincipal.getRealm();
    }

    public KerberosTime getEndTime() {
        return this._endTime;
    }

    public TicketFlags getFlags() {
        return this._flags;
    }

    public EncryptionKey getSessionKey() {
        return this._sessionKey;
    }

    public KerberosTime getRenewTill() {
        return this._renewTill;
    }

    public KerberosTime getStartTime() {
        return this._startTime;
    }

    public TransitedEncoding getTransitedEncoding() {
        return this._transitedEncoding;
    }
}

