/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.sam;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.kerberos.crypto.encryption.EncryptionEngine;
import org.apache.kerberos.crypto.encryption.EncryptionEngineFactory;
import org.apache.kerberos.crypto.encryption.EncryptionType;
import org.apache.kerberos.exceptions.KerberosException;
import org.apache.kerberos.io.decoder.EncryptedDataDecoder;
import org.apache.kerberos.io.decoder.EncryptedTimestampDecoder;
import org.apache.kerberos.messages.value.EncryptedData;
import org.apache.kerberos.messages.value.EncryptedTimeStamp;
import org.apache.kerberos.messages.value.EncryptionKey;
import org.apache.kerberos.messages.value.KerberosTime;
import org.apache.kerberos.sam.KeyIntegrityChecker;

public class TimestampChecker
implements KeyIntegrityChecker {
    private static final long FIVE_MINUTES = 300000L;

    public boolean checkKeyIntegrity(byte[] encryptedData, KerberosKey kerberosKey) {
        EncryptionType keyType = EncryptionType.getTypeByOrdinal(kerberosKey.getKeyType());
        EncryptionKey key = new EncryptionKey(keyType, kerberosKey.getEncoded());
        try {
            EncryptedData sadValue = EncryptedDataDecoder.decode(encryptedData);
            EncryptionEngine engine = EncryptionEngineFactory.getEncryptionEngineFor(key);
            byte[] decryptedTimestamp = engine.getDecryptedData(key, sadValue);
            EncryptedTimestampDecoder decoder = new EncryptedTimestampDecoder();
            EncryptedTimeStamp timestamp = decoder.decode(decryptedTimestamp);
            KerberosTime time = timestamp.getTimeStamp();
            if (time.isInClockSkew(300000L)) {
                return true;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (KerberosException ke) {
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
        return false;
    }
}

