/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.service;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.kerberos.crypto.encryption.EncryptionType;

public class KdcConfiguration {
    private static final String KDC_PRIMARY_REALM = "kdc.primary.realm";
    private static final String KDC_PRINCIPAL = "kdc.principal";
    public static final int DEFAULT_KERBEROS_PORT = 88;
    public static final int DEFAULT_CHANGEPW_PORT = 464;
    public static final String KERBEROS_PORT_KEY = "kdc.default.port";
    public static final String CHANGEPW_PORT_KEY = "changepw.default.port";
    private static final int BUFFER_SIZE = 1024;
    private static final int MINUTE = 60000;
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private static final String DEFAULT_CHANGEPW_PRINCIPAL = "kadmin/changepw@EXAMPLE.COM";
    private final Properties properties = new Properties();
    private EncryptionType[] _encryptionTypes;

    public KdcConfiguration() {
        this.prepareEncryptionTypes();
    }

    public KdcConfiguration(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.prepareEncryptionTypes();
    }

    public String getPrimaryRealm() {
        String key = KDC_PRIMARY_REALM;
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return DEFAULT_REALM;
    }

    public KerberosPrincipal getKdcPrincipal() {
        String key = KDC_PRINCIPAL;
        if (this.properties.containsKey(key)) {
            return new KerberosPrincipal(this.properties.getProperty(key));
        }
        return new KerberosPrincipal(DEFAULT_PRINCIPAL);
    }

    public EncryptionType[] getEncryptionTypes() {
        return this._encryptionTypes;
    }

    public Hashtable getProperties() {
        this.properties.setProperty("java.naming.ldap.attributes.binary", "krb5Key");
        return this.properties;
    }

    public long getClockSkew() {
        String key = "kdc.allowable.clockskew";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong(this.properties.getProperty(key));
        }
        return 300000L;
    }

    public long getMaximumTicketLifetime() {
        String key = "tgs.maximum.ticket.lifetime";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong(this.properties.getProperty(key));
        }
        return 86400000L;
    }

    public long getMaximumRenewableLifetime() {
        String key = "tgs.maximum.renewable.lifetime";
        if (this.properties.containsKey(key)) {
            return 60000L * Long.parseLong(this.properties.getProperty(key));
        }
        return 604800000L;
    }

    public int getDefaultPort() {
        String key = KERBEROS_PORT_KEY;
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        return 88;
    }

    public int getBufferSize() {
        String key = "kdc.buffer.size";
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        return 1024;
    }

    public boolean isPaEncTimestampRequired() {
        String key = "kdc.pa.enc.timestamp.required";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public boolean isEmptyAddressesAllowed() {
        String key = "tgs.empty.addresses.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public boolean isForwardableAllowed() {
        String key = "tgs.forwardable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public boolean isProxiableAllowed() {
        String key = "tgs.proxiable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public boolean isPostdateAllowed() {
        String key = "tgs.postdate.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public boolean isRenewableAllowed() {
        String key = "tgs.renewable.allowed";
        if (this.properties.containsKey(key)) {
            return "true".equalsIgnoreCase(this.properties.getProperty(key));
        }
        return true;
    }

    public int getChangepwPort() {
        String key = CHANGEPW_PORT_KEY;
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.getProperty(key));
        }
        return 464;
    }

    public KerberosPrincipal getChangepwPrincipal() {
        String key = "changepw.principal";
        if (this.properties.containsKey(key)) {
            return new KerberosPrincipal(this.properties.getProperty(key));
        }
        return new KerberosPrincipal(DEFAULT_CHANGEPW_PRINCIPAL);
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypes = null;
        String key = "kdc.encryption.types";
        encryptionTypes = this.properties.containsKey(key) ? this.properties.getProperty(key).split("\\s") : new String[]{"des-cbc-md5"};
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (int i = 0; i < encryptionTypes.length; ++i) {
            String enc = encryptionTypes[i];
            Iterator it = EncryptionType.VALUES.iterator();
            while (it.hasNext()) {
                EncryptionType type = (EncryptionType)it.next();
                if (!type.toString().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this._encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }
}

