/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder;

import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.ReferralImpl;
import org.apache.ldap.common.message.ResultResponse;

public class ReferralRule
extends AbstractRule {
    private static final TagEnum TAG = new TagEnum("Referral", -2097152000, 3){};

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        super.tag(id, isPrimitive, typeClass);
        if (id != TAG.getTagId()) {
            throw new IllegalArgumentException("Expecting " + TAG.getName() + " with an id of " + TAG.getTagId() + " but instead got a tag id of " + id);
        }
        ResultResponse resp = (ResultResponse)this.getDigester().getRoot();
        LdapResult result = resp.getLdapResult();
        ReferralImpl ref = new ReferralImpl(result);
        result.setReferral(ref);
        this.getDigester().push(ref);
    }

    public void finish() {
        super.finish();
        this.getDigester().pop();
    }
}

