/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.commons.lang.Validate;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.decoder.search.SearchRequestProcessing;
import org.apache.ldap.common.message.SearchRequestImpl;

public class BaseSearchRequestRule
extends AbstractRule {
    private boolean isEnabled = true;
    private final int minTagCount;
    private SearchRequestImpl req;
    private SearchRequestProcessing processing;

    protected BaseSearchRequestRule(int minTagCount) {
        Validate.isTrue(minTagCount >= 2, "minimum tag count must be 2 or more");
        this.minTagCount = minTagCount;
    }

    protected SearchRequestImpl getRequest() {
        return this.req;
    }

    protected SearchRequestProcessing getProcessing() {
        return this.processing;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < this.minTagCount) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
        int ii = this.getDigester().getCount() - 1;
        this.req = (SearchRequestImpl)this.getDigester().peek(ii);
        this.processing = (SearchRequestProcessing)this.getDigester().peek(ii - 1);
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isEnabled) {
            this.processing.next();
            super.finish();
        }
        this.req = null;
        this.isEnabled = true;
        this.processing = null;
    }
}

